/*
 * Decompiled with CFR 0.152.
 */
package cck.util;

import cck.util.Option;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;

public class Options {
    protected final HashMap knownValues = new HashMap();
    protected String[] arguments;

    public Option.Bool newOption(String name, boolean val, String desc) {
        Option.Bool o = new Option.Bool(name, val, desc);
        this.knownValues.put(name, o);
        return o;
    }

    public Option.Str newOption(String name, String val, String desc) {
        Option.Str o = new Option.Str(name, val, desc);
        this.knownValues.put(name, o);
        return o;
    }

    public Option.List newOptionList(String name, String val, String desc) {
        Option.List o = new Option.List(name, val, desc);
        this.knownValues.put(name, o);
        return o;
    }

    public Option.Long newOption(String name, long val, String desc) {
        Option.Long o = new Option.Long(name, val, desc);
        this.knownValues.put(name, o);
        return o;
    }

    public Option.Double newOption(String name, double val, String desc) {
        Option.Double o = new Option.Double(name, val, desc);
        this.knownValues.put(name, o);
        return o;
    }

    public Option.Interval newOption(String name, long l, long h, String desc) {
        Option.Interval o = new Option.Interval(name, l, h, desc);
        this.knownValues.put(name, o);
        return o;
    }

    public String getOptionValue(String name) {
        Option option = (Option)this.knownValues.get(name);
        return option == null ? null : option.stringValue();
    }

    public String getOptionValue(String name, String def) {
        Option option = (Option)this.knownValues.get(name);
        return option == null ? def : option.stringValue();
    }

    public Option getOption(String name) {
        return (Option)this.knownValues.get(name);
    }

    public boolean hasOption(String name) {
        return this.knownValues.get(name) != null;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void parseCommandLine(String[] args) {
        int cntr;
        for (cntr = 0; cntr < args.length && args[cntr].charAt(0) == '-'; ++cntr) {
            this.parseOption(args[cntr]);
        }
        int left = args.length - cntr;
        this.arguments = new String[left];
        System.arraycopy(args, cntr, this.arguments, 0, left);
    }

    protected void parseOption(String opt) {
        String value;
        String optname;
        int index = opt.indexOf(61);
        if (index < 0) {
            optname = opt.substring(1, opt.length());
            value = "";
        } else {
            value = opt.substring(index + 1);
            optname = opt.substring(1, index);
        }
        this.setOption(optname, value);
    }

    public void setOption(String optname, String value) {
        Option option = (Option)this.knownValues.get(optname);
        if (option == null) {
            option = new Option.Str(optname, value, "");
            this.knownValues.put(optname, option);
        }
        option.set(value);
    }

    public Collection getAllOptions() {
        return this.knownValues.values();
    }

    public void process(Options o) {
        for (String name : o.knownValues.keySet()) {
            String val = ((Option)o.knownValues.get(name)).stringValue();
            this.setOption(name, val);
        }
    }

    public void process(Properties p) {
        for (String string : p.keySet()) {
            String val = p.getProperty(string);
            this.setOption(string, val);
        }
    }

    public void loadFile(String fname) throws IOException {
        File f = new File(fname);
        Properties defs = new Properties();
        defs.load(new FileInputStream(f));
        this.process(defs);
    }
}

