/*
 * Decompiled with CFR 0.152.
 */
package cck.util;

import cck.text.StringUtil;
import cck.text.Terminal;
import cck.util.Util;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Comparator;
import java.util.Iterator;

public abstract class Option {
    protected final String name;
    protected final String description;
    public static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            Option opt1 = (Option)o1;
            Option opt2 = (Option)o2;
            return String.CASE_INSENSITIVE_ORDER.compare(opt1.getName(), opt2.getName());
        }
    };

    public Option(String n, String d) {
        this.name = n;
        this.description = d;
    }

    public String getName() {
        return this.name;
    }

    public abstract void set(String var1);

    public abstract String stringValue();

    public abstract void printHelp();

    public void printDescription() {
        Terminal.print(StringUtil.formatParagraphs(this.description, 8, 0, 78));
        Terminal.nextln();
    }

    public void printHeader(String type, String defvalue) {
        Terminal.printGreen("    -" + this.name);
        Terminal.print(": ");
        Terminal.printBrightCyan(type);
        Terminal.print(" = ");
        Terminal.printYellow(defvalue);
        Terminal.nextln();
    }

    protected void parseError(String name, String type, String val) {
        Util.userError("Option Error", "invalid value for " + type + " option " + StringUtil.quote(name) + " = " + StringUtil.quote(val));
    }

    public static class Bool
    extends Option {
        protected final boolean defvalue;
        protected boolean value;

        public Bool(String nm, boolean val, String desc) {
            super(nm, desc);
            this.value = val;
            this.defvalue = val;
        }

        public void set(String val) {
            if ("true".equals(val) || "".equals(val)) {
                this.value = true;
            } else if ("false".equals(val)) {
                this.value = false;
            } else {
                this.parseError(this.name, "boolean", val);
            }
        }

        public boolean get() {
            return this.value;
        }

        public String stringValue() {
            return String.valueOf(this.value);
        }

        public void printHelp() {
            this.printHeader("boolean", String.valueOf(this.defvalue));
            this.printDescription();
        }
    }

    public static class List
    extends Option {
        protected java.util.List value;
        protected String orig;

        public List(String nm, String val, String desc) {
            super(nm, desc);
            this.parseString(val);
        }

        public void set(String val) {
            this.parseString(val);
        }

        public void setNewDefault(String val) {
            this.parseString(val);
        }

        public java.util.List get() {
            return this.value;
        }

        public String stringValue() {
            return this.orig;
        }

        private void parseString(String val) {
            this.orig = val;
            this.value = StringUtil.toList(val);
        }

        public String[] toArray() {
            String[] result = new String[this.value.size()];
            Iterator i = this.value.iterator();
            int cntr = 0;
            while (i.hasNext()) {
                result[cntr++] = (String)i.next();
            }
            return result;
        }

        public void printHelp() {
            String defvalue = "".equals(this.orig) ? "(null)" : this.orig;
            this.printHeader("list", defvalue);
            this.printDescription();
        }
    }

    public static class Str
    extends Option {
        protected String defvalue;
        protected String value;

        public Str(String nm, String val, String desc) {
            super(nm, desc);
            this.defvalue = this.value = val;
        }

        public void set(String val) {
            this.value = val;
        }

        public void setNewDefault(String val) {
            this.defvalue = val;
            this.value = val;
        }

        public String get() {
            return this.value;
        }

        public String stringValue() {
            return this.value;
        }

        public void printHelp() {
            this.printHeader("string", this.defvalue);
            this.printDescription();
        }

        public boolean isBlank() {
            return "".equals(this.value);
        }
    }

    public static class Interval
    extends Option {
        protected final long default_low;
        protected final long default_high;
        protected long low;
        protected long high;

        public Interval(String nm, long l, long h, String desc) {
            super(nm, desc);
            this.default_low = this.low = l;
            this.default_high = this.high = h;
        }

        public void set(String val) {
            StringCharacterIterator iter = new StringCharacterIterator(val);
            try {
                if (!StringUtil.peekAndEat((CharacterIterator)iter, '[')) {
                    this.parseError(this.name, "interval", val);
                }
                String lstr = StringUtil.readDecimalString(iter, 12);
                this.low = java.lang.Long.parseLong(lstr);
                if (!StringUtil.peekAndEat((CharacterIterator)iter, ',')) {
                    this.parseError(this.name, "interval", val);
                }
                String hstr = StringUtil.readDecimalString(iter, 12);
                this.high = java.lang.Long.parseLong(hstr);
                if (!StringUtil.peekAndEat((CharacterIterator)iter, ']')) {
                    this.parseError(this.name, "interval", val);
                }
            }
            catch (NumberFormatException e) {
                this.parseError(this.name, "interval", val);
            }
        }

        public long getLow() {
            return this.low;
        }

        public long getHigh() {
            return this.high;
        }

        public String stringValue() {
            return "[" + this.low + ", " + this.high + ']';
        }

        public void printHelp() {
            this.printHeader("interval", "[" + this.default_low + ',' + this.default_high + ']');
            this.printDescription();
        }
    }

    public static class Double
    extends Option {
        protected final double defvalue;
        protected double value;

        public Double(String nm, double val, String desc) {
            super(nm, desc);
            this.value = val;
            this.defvalue = val;
        }

        public void set(String val) {
            try {
                this.value = java.lang.Double.parseDouble(val);
            }
            catch (Exception e) {
                this.parseError(this.name, "double", val);
            }
        }

        public double get() {
            return this.value;
        }

        public String stringValue() {
            return String.valueOf(this.value);
        }

        public void printHelp() {
            this.printHeader("double", String.valueOf(this.defvalue));
            this.printDescription();
        }
    }

    public static class Long
    extends Option {
        protected final long defvalue;
        protected long value;

        public Long(String nm, long val, String desc) {
            super(nm, desc);
            this.value = val;
            this.defvalue = val;
        }

        public void set(String val) {
            try {
                this.value = java.lang.Long.parseLong(val);
            }
            catch (Exception e) {
                this.parseError(this.name, "long", val);
            }
        }

        public long get() {
            return this.value;
        }

        public String stringValue() {
            return String.valueOf(this.value);
        }

        public void printHelp() {
            this.printHeader("long", String.valueOf(this.defvalue));
            this.printDescription();
        }
    }
}

