/*
 * Decompiled with CFR 0.152.
 */
package cck.util;

import cck.text.StringUtil;
import cck.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ClassMap {
    protected final String type;
    protected final Class clazz;
    protected final HashMap classMap;
    protected final HashMap reverseMap;
    protected final HashMap objMap;

    public ClassMap(String t, Class clz) {
        this.clazz = clz;
        this.classMap = new HashMap();
        this.reverseMap = new HashMap();
        this.objMap = new HashMap();
        this.type = t;
    }

    public void addClass(String alias, Class clz) {
        this.classMap.put(alias, clz);
        this.reverseMap.put(clz, alias);
    }

    public void addInstance(String alias, Object o) {
        Class<?> cz = o.getClass();
        if (!this.clazz.isAssignableFrom(cz)) {
            throw Util.failure("Object of class " + StringUtil.quote(cz) + " is not an instance of " + this.clazz.getName());
        }
        this.objMap.put(alias, o);
        this.classMap.put(alias, cz);
        this.reverseMap.put(o, alias);
    }

    public Class getClass(String shortName) {
        Object o = this.objMap.get(shortName);
        if (o != null) {
            return o.getClass();
        }
        return (Class)this.classMap.get(shortName);
    }

    public Object getObjectOfClass(String name) {
        Object o = this.objMap.get(name);
        if (o != null) {
            return o;
        }
        String clname = StringUtil.quote(name);
        Class<?> c = (Class<?>)this.classMap.get(name);
        if (c == null) {
            try {
                c = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                Util.userError(this.type + " class not found", clname);
            }
        } else {
            clname = clname + " (" + c.toString() + ')';
        }
        if (!this.clazz.isAssignableFrom(c)) {
            Util.userError("The specified class does not extend " + this.clazz.getName(), clname);
        }
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            Util.userError("The specified class does not have a default constructor", clname);
        }
        catch (IllegalAccessException e) {
            Util.userError("Illegal access to class", clname);
        }
        throw Util.unreachable();
    }

    public String getAlias(Object o) {
        String s = (String)this.reverseMap.get(o);
        if (s == null) {
            s = (String)this.reverseMap.get(o.getClass());
        }
        if (s == null) {
            s = o.getClass().getName();
        }
        return s;
    }

    public List getSortedList() {
        ArrayList list = Collections.list(Collections.enumeration(this.classMap.keySet()));
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    public Iterator getIterator() {
        return this.classMap.keySet().iterator();
    }

    public Iterator iterator() {
        return this.classMap.keySet().iterator();
    }
}

