/*
 * Decompiled with CFR 0.152.
 */
package cck.util;

public class Arithmetic {
    private static final int[] reverseKey = new int[]{0, 8, 4, 12, 2, 10, 6, 14, 1, 9, 5, 13, 3, 11, 7, 15};
    private static final int[] bitcountKey = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};

    public static short word(byte b1, byte b2) {
        return (short)(b1 & 0xFF | b2 << 8);
    }

    public static char uword(byte b1, byte b2) {
        return (char)(b1 & 0xFF | (b2 & 0xFF) << 8);
    }

    public static int signExtend(int value, int signbit) {
        if (Arithmetic.getBit(value, signbit)) {
            return value | -1 << signbit;
        }
        return value;
    }

    public static char ubyte(byte b1) {
        return (char)(b1 & 0xFF);
    }

    public static byte low(short val) {
        return (byte)val;
    }

    public static byte high(short val) {
        return (byte)(val >> 8);
    }

    public static byte low(int val) {
        return (byte)val;
    }

    public static byte high(int val) {
        return (byte)((val & 0xFF00) >> 8);
    }

    public static char ulow(char val) {
        return (char)(val & 0xFF);
    }

    public static char uhigh(char val) {
        return (char)(val >> 8);
    }

    public static char ulow(short val) {
        return (char)(val & 0xFF);
    }

    public static char uhigh(short val) {
        return (char)((val & 0xFF00) >> 8);
    }

    public static boolean getBit(byte val, int bit) {
        return (val & 1 << bit) != 0;
    }

    public static boolean getBit(long val, int bit) {
        return (val & 1L << bit) != 0L;
    }

    public static boolean getBit(int val, int bit) {
        return (val & 1 << bit) != 0;
    }

    public static byte setBit(byte val, int bit) {
        return (byte)(val | 1 << bit);
    }

    public static byte setBit(byte val, int bit, boolean on) {
        if (on) {
            return Arithmetic.setBit(val, bit);
        }
        return Arithmetic.clearBit(val, bit);
    }

    public static int setBit(int val, int bit, boolean on) {
        int mask = 1 << bit;
        return on ? val | mask : val & ~mask;
    }

    public static long setBit(long val, int bit, boolean on) {
        long mask = 1L << bit;
        return on ? val | mask : val & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static byte clearBit(byte val, int bit) {
        return (byte)(val & ~(1 << bit));
    }

    public static int lowestBit(long value) {
        int low = 0;
        if ((int)value == 0) {
            low += 32;
            value >>= 32;
        }
        if ((value & 0xFFFFL) == 0L) {
            low += 16;
            value >>= 16;
        }
        if ((value & 0xFFL) == 0L) {
            low += 8;
            value >>= 8;
        }
        if ((value & 0xFL) == 0L) {
            low += 4;
            value >>= 4;
        }
        if ((value & 3L) == 0L) {
            low += 2;
            value >>= 2;
        }
        if ((value & 1L) == 0L) {
            ++low;
            value >>= 1;
        }
        return value == 0L ? -1 : low;
    }

    public static int highestBit(int value) {
        int high = 31;
        if ((value & 0xFFFF0000) == 0) {
            high -= 16;
            value <<= 16;
        }
        if ((value & 0xFF000000) == 0) {
            high -= 8;
            value <<= 8;
        }
        if ((value & 0xF0000000) == 0) {
            high -= 4;
            value <<= 4;
        }
        if ((value & 0xC0000000) == 0) {
            high -= 2;
            value <<= 2;
        }
        if ((value & Integer.MIN_VALUE) == 0) {
            --high;
            value <<= 1;
        }
        return value == 0 ? -1 : high;
    }

    public static int log(int value) {
        if (value == 0) {
            return 0;
        }
        return 1 + Arithmetic.highestBit(value - 1);
    }

    public static int getBitField(int value, int[] permutation) {
        int result = 0;
        for (int cntr = 0; cntr < permutation.length; ++cntr) {
            result <<= 1;
            if (!Arithmetic.getBit(value, permutation[cntr])) continue;
            result |= 1;
        }
        return result;
    }

    public static int getBitField(int value, int lowbit, int length) {
        return value >> lowbit & -1 >>> 32 - length;
    }

    public static byte reverseBits(byte value) {
        return (byte)(reverseKey[value & 0xF] << 4 | reverseKey[value >> 4 & 0xF]);
    }

    public static int bitCount(byte value) {
        return bitcountKey[value & 0xF] + bitcountKey[value >> 4 & 0xF];
    }

    public static int getSingleBitMask(int bit) {
        return 1 << bit;
    }

    public static int getSingleInverseBitMask(int bit) {
        return ~(1 << bit);
    }

    public static int getBitRangeMask(int low, int high) {
        return -1 >>> 31 - (high - low) << low;
    }

    public static int getBitMask(int width) {
        return -1 >>> 31 - (width - 1);
    }

    public static long getLongBitRangeMask(int low, int high) {
        return -1L >>> 63 - (high - low) << low;
    }

    public static int getInverseBitRangeMask(int low, int high) {
        return ~Arithmetic.getBitRangeMask(low, high);
    }

    public static long[] modulus(long val, int[] denom) {
        long[] result = new long[denom.length + 1];
        for (int cntr = denom.length - 1; cntr >= 0; --cntr) {
            int radix = denom[cntr];
            result[cntr + 1] = val % (long)radix;
            val /= (long)radix;
        }
        result[0] = val;
        return result;
    }

    public static long mult(long[] vals, int[] denom) {
        long accum = 0L;
        int radix = 1;
        assert (vals.length - 1 == denom.length);
        for (int cntr = 0; cntr < vals.length - 1; ++cntr) {
            accum += vals[cntr] * (long)radix;
            radix *= denom[cntr];
        }
        return accum += vals[vals.length - 1] * (long)radix;
    }

    public static void inc(long[] vals, int[] denom, int pos) {
        assert (vals.length - 1 == denom.length);
        for (int cntr = pos; cntr < vals.length; ++cntr) {
            int n = cntr;
            vals[n] = vals[n] + 1L;
            if (vals[cntr] < (long)denom[cntr]) break;
        }
    }

    public static int max(int m1, int m2) {
        return m1 > m2 ? m1 : m2;
    }

    public static int min(int m1, int m2) {
        return m1 < m2 ? m1 : m2;
    }

    public static byte packBits(boolean b0, boolean b1, boolean b2, boolean b3, boolean b4, boolean b5, boolean b6, boolean b7) {
        int val = 0;
        if (b0) {
            val |= 1;
        }
        if (b1) {
            val |= 2;
        }
        if (b2) {
            val |= 4;
        }
        if (b3) {
            val |= 8;
        }
        if (b4) {
            val |= 0x10;
        }
        if (b5) {
            val |= 0x20;
        }
        if (b6) {
            val |= 0x40;
        }
        if (b7) {
            val |= 0x80;
        }
        return (byte)val;
    }

    public static int roundup(int val, int den) {
        return (val + den - 1) / 8;
    }
}

