/*
 * Decompiled with CFR 0.152.
 */
package cck.text;

import cck.text.StringUtil;
import java.util.HashMap;

public class Verbose {
    static boolean ALL;
    static final HashMap printerMap;
    static final Printer verbosePrinter;

    public static Printer getVerbosePrinter(String category) {
        Printer p = Verbose.getPrinter(category);
        if (verbosePrinter != null && Verbose.verbosePrinter.enabled) {
            verbosePrinter.println("verbose: requested printer for " + StringUtil.quote(category));
        }
        return p;
    }

    public static void setVerbose(String category, boolean on) {
        if ("all".equals(category)) {
            ALL = on;
            for (Printer p : printerMap.values()) {
                p.enabled = on;
            }
            return;
        }
        Printer p = Verbose.getPrinter(category);
        if (verbosePrinter != null && Verbose.verbosePrinter.enabled) {
            verbosePrinter.println("verbose: set printer " + StringUtil.quote(category) + " to " + on);
        }
        p.enabled = on;
    }

    private static Printer getPrinter(String category) {
        Printer p = (Printer)printerMap.get(category);
        if (p == null) {
            p = new Printer();
            printerMap.put(category, p);
        }
        return p;
    }

    static {
        printerMap = new HashMap();
        verbosePrinter = Verbose.getVerbosePrinter("verbose");
    }

    public static class Printer
    extends cck.text.Printer {
        public boolean enabled = ALL;

        Printer() {
            super(System.out);
        }

        public void println(String s) {
            if (this.enabled) {
                super.println(s);
            }
        }

        public void print(String s) {
            if (this.enabled) {
                super.print(s);
            }
        }

        public void nextln() {
            if (this.enabled) {
                super.nextln();
            }
        }

        public void indent() {
            if (this.enabled) {
                super.indent();
            }
        }

        public void spaces() {
            if (this.enabled) {
                super.spaces();
            }
        }

        public void unindent() {
            if (this.enabled) {
                super.unindent();
            }
        }

        public void startblock() {
            if (this.enabled) {
                super.startblock();
            }
        }

        public void startblock(String name) {
            if (this.enabled) {
                super.startblock(name);
            }
        }

        public void endblock() {
            if (this.enabled) {
                super.endblock();
            }
        }
    }
}

