/*
 * Decompiled with CFR 0.152.
 */
package cck.text;

import java.io.PrintStream;

public class Terminal {
    public static boolean useColors = true;
    public static boolean htmlColors;
    public static final int MAXLINE = 78;
    private static PrintStream out;
    public static final int COLOR_BLACK = 0;
    public static final int COLOR_RED = 1;
    public static final int COLOR_GREEN = 2;
    public static final int COLOR_BROWN = 3;
    public static final int COLOR_BLUE = 4;
    public static final int COLOR_PURPLE = 5;
    public static final int COLOR_CYAN = 6;
    public static final int COLOR_LIGHTGRAY = 7;
    public static final int COLOR_DARKGRAY = 8;
    public static final int COLOR_BRIGHT_RED = 9;
    public static final int COLOR_BRIGHT_GREEN = 10;
    public static final int COLOR_YELLOW = 11;
    public static final int COLOR_BRIGHT_BLUE = 12;
    public static final int COLOR_MAGENTA = 13;
    public static final int COLOR_BRIGHT_CYAN = 14;
    public static final int COLOR_WHITE = 15;
    public static final int COLOR_DEFAULT = 16;
    public static final int MAXCOLORS = 16;
    private static final String CTRL_BLACK = "\u001b[0;30m";
    private static final String CTRL_RED = "\u001b[0;31m";
    private static final String CTRL_GREEN = "\u001b[0;32m";
    private static final String CTRL_BROWN = "\u001b[0;33m";
    private static final String CTRL_BLUE = "\u001b[0;34m";
    private static final String CTRL_PURPLE = "\u001b[0;35m";
    private static final String CTRL_CYAN = "\u001b[0;36m";
    private static final String CTRL_LIGHTGRAY = "\u001b[0;37m";
    private static final String CTRL_DARKGRAY = "\u001b[1;30m";
    private static final String CTRL_BRIGHT_RED = "\u001b[1;31m";
    private static final String CTRL_BRIGHT_GREEN = "\u001b[1;32m";
    private static final String CTRL_YELLOW = "\u001b[1;33m";
    private static final String CTRL_BRIGHT_BLUE = "\u001b[1;34m";
    private static final String CTRL_MAGENTA = "\u001b[1;35m";
    private static final String CTRL_BRIGHT_CYAN = "\u001b[1;36m";
    private static final String CTRL_WHITE = "\u001b[1;37m";
    private static final String CTRL_DEFAULT = "\u001b[1;00m";
    private static final String[] COLORS;
    private static final String[] HTML_COLORS;
    private static final String[] HTML_STRINGS;
    public static final int ERROR_COLOR = 1;
    public static final int WARN_COLOR = 11;

    public static void print(int[] colors, String[] s) {
        for (int cntr = 0; cntr < s.length; ++cntr) {
            if (cntr < colors.length) {
                Terminal.print(colors[cntr], s[cntr]);
                continue;
            }
            Terminal.print(s[cntr]);
        }
    }

    public static void print(int color, String s) {
        if (color >= 16 || color < 0) {
            Terminal.print(s);
        } else {
            Terminal.outputColor(color, s);
        }
    }

    public static void println(int color, String s) {
        Terminal.print(color, s);
        out.print('\n');
    }

    public static void append(int color, StringBuffer buf, String s) {
        if (useColors && color < 16 && color >= 0) {
            if (htmlColors) {
                buf.append(HTML_STRINGS[color]);
                buf.append(s);
                buf.append("</font>");
                return;
            }
            if (color != 16) {
                buf.append(COLORS[color]);
                buf.append(s);
                buf.append(COLORS[16]);
                return;
            }
        }
        buf.append(s);
    }

    public static void print(String s) {
        out.print(s);
    }

    public static void println(String s) {
        out.println(s);
    }

    public static void nextln() {
        out.print("\n");
    }

    public static void setOutput(PrintStream s) {
        out = s;
    }

    public static void printRed(String s) {
        Terminal.outputColor(1, s);
    }

    public static void printBlue(String s) {
        Terminal.outputColor(4, s);
    }

    public static void printGreen(String s) {
        Terminal.outputColor(2, s);
    }

    public static void printYellow(String s) {
        Terminal.outputColor(11, s);
    }

    public static void printCyan(String s) {
        Terminal.outputColor(6, s);
    }

    public static void printBrightRed(String s) {
        Terminal.outputColor(9, s);
    }

    public static void printBrightBlue(String s) {
        Terminal.outputColor(12, s);
    }

    public static void printBrightGreen(String s) {
        Terminal.outputColor(10, s);
    }

    public static void printBrightCyan(String s) {
        Terminal.outputColor(14, s);
    }

    public static void flush() {
        out.flush();
    }

    public static void printPair(int c1, int c2, String s1, String sep, String s2) {
        Terminal.print(c1, s1);
        Terminal.print(sep);
        Terminal.print(c2, s2);
    }

    public static void printTriple(int c1, int c2, int c3, String s1, String sep1, String s2, String sep2, String s3) {
        Terminal.print(c1, s1);
        Terminal.print(sep1);
        Terminal.print(c2, s2);
        Terminal.print(sep2);
        Terminal.print(c3, s3);
    }

    private static void outputColor(int color, String s) {
        if (color < 0) {
            color = 16;
        }
        if (useColors) {
            if (htmlColors) {
                out.print(HTML_STRINGS[color]);
                out.print(s);
                out.print("</font>");
                return;
            }
            if (color != 16) {
                out.print(COLORS[color]);
                out.print(s);
                out.print(COLORS[16]);
                return;
            }
        }
        out.print(s);
    }

    static {
        out = System.out;
        COLORS = new String[]{CTRL_BLACK, CTRL_RED, CTRL_GREEN, CTRL_BROWN, CTRL_BLUE, CTRL_PURPLE, CTRL_CYAN, CTRL_LIGHTGRAY, CTRL_DARKGRAY, CTRL_BRIGHT_RED, CTRL_BRIGHT_GREEN, CTRL_YELLOW, CTRL_BRIGHT_BLUE, CTRL_MAGENTA, CTRL_BRIGHT_CYAN, CTRL_WHITE, CTRL_DEFAULT};
        HTML_COLORS = new String[]{"black", "red", "green", "brown", "blue", "purple", "cyan", "lightgray", "gray", "pink", "green", "yellow", "blue", "magenta", "cyan", "white"};
        HTML_STRINGS = new String[HTML_COLORS.length];
        for (int cntr = 0; cntr < HTML_STRINGS.length; ++cntr) {
            Terminal.HTML_STRINGS[cntr] = "<font color=" + HTML_COLORS[cntr] + '>';
        }
    }
}

