/*
 * Decompiled with CFR 0.152.
 */
package cck.text;

import cck.text.StringUtil;
import cck.text.Terminal;

public class TermUtil {
    public static void reportQuantity(String name, long val, String units) {
        TermUtil.reportQuantity(name, Long.toString(val), units);
    }

    public static void reportProportion(String name, long val, long total, String units) {
        String sval = Long.toString(val);
        Terminal.printGreen(name);
        Terminal.print(": ");
        Terminal.printBrightCyan(sval);
        if (units != null && units.length() > 0) {
            Terminal.print(' ' + units + ' ');
        } else {
            Terminal.print(" ");
        }
        float pcnt = 100.0f * (float)val / (float)total;
        Terminal.printBrightCyan(StringUtil.toFixedFloat(pcnt, 4));
        Terminal.println(" %");
    }

    public static void reportQuantity(String name, float val, String units) {
        TermUtil.reportQuantity(name, Float.toString(val), units);
    }

    public static void reportQuantity(String name, String val, String units) {
        Terminal.printGreen(name);
        Terminal.print(": ");
        Terminal.printBrightCyan(val);
        Terminal.println(' ' + units);
    }

    public static void printSeparator(int width) {
        Terminal.println(StringUtil.dup('=', width));
    }

    public static void printSeparator() {
        Terminal.println(StringUtil.dup('=', 78));
    }

    public static void printThinSeparator(int width) {
        Terminal.println(StringUtil.dup('-', width));
    }

    public static void printThinSeparator() {
        Terminal.println(StringUtil.dup('-', 78));
    }

    public static void printSeparator(int width, String header) {
        Terminal.print("=={ ");
        Terminal.print(header);
        Terminal.print(" }");
        Terminal.print(StringUtil.dup('=', width - 6 - header.length()));
        Terminal.nextln();
    }

    public static void printSeparator(String header) {
        TermUtil.printSeparator(78, header);
    }
}

