/*
 * Decompiled with CFR 0.152.
 */
package cck.text;

import cck.text.CharUtil;
import cck.util.Arithmetic;
import cck.util.Util;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class StringUtil {
    public static final String QUOTE = "\"";
    public static final String SQUOTE = "'";
    public static final String LPAREN = "(";
    public static final String RPAREN = ")";
    public static final String COMMA = ",";
    public static final String COMMA_SPACE = ", ";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final char SQUOTE_CHAR = '\'';
    public static final char BACKSLASH = '\\';
    public static final char QUOTE_CHAR = '\"';
    protected static final String[] spacers = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          "};

    public static String addrToString(int address) {
        return StringUtil.to0xHex(address, 4);
    }

    public static String baseFileName(String f) {
        int dind;
        int sind = f.lastIndexOf(47);
        if (sind >= 0) {
            f = f.substring(sind + 1);
        }
        if ((dind = f.lastIndexOf(46)) >= 0) {
            f = f.substring(0, dind);
        }
        return f;
    }

    public static String readIdentifier(CharacterIterator i) {
        char c;
        StringBuffer buf = new StringBuffer();
        while (Character.isLetterOrDigit(c = i.current()) || c == '_') {
            buf.append(c);
            i.next();
        }
        return buf.toString();
    }

    public static String readDotIdentifier(CharacterIterator i) {
        char c;
        StringBuffer buf = new StringBuffer();
        while (Character.isLetterOrDigit(c = i.current()) || c == '_' || c == '.') {
            buf.append(c);
            i.next();
        }
        return buf.toString();
    }

    public static int readHexValue(CharacterIterator i, int max_chars) {
        char c;
        int accumul = 0;
        for (int cntr = 0; cntr < max_chars && (c = i.current()) != '\uffff' && StringUtil.isHexDigit(c); ++cntr) {
            accumul = accumul << 4 | StringUtil.hexValueOf(c);
            i.next();
        }
        return accumul;
    }

    public static int readOctalValue(CharacterIterator i, int max_chars) {
        char c;
        int accumul = 0;
        for (int cntr = 0; cntr < max_chars && StringUtil.isOctalDigit(c = i.current()); ++cntr) {
            accumul = accumul << 3 | StringUtil.octalValueOf(c);
            i.next();
        }
        return accumul;
    }

    public static int readBinaryValue(CharacterIterator i, int max_chars) {
        int accumul = 0;
        for (int cntr = 0; cntr < max_chars; ++cntr) {
            char ch = i.current();
            i.next();
            if (ch == '0') {
                accumul <<= 1;
                continue;
            }
            if (ch != '1') break;
            accumul = accumul << 1 | 1;
        }
        return accumul;
    }

    public static int readDecimalValue(CharacterIterator i, int max_chars) {
        return Integer.parseInt(StringUtil.readDecimalString(i, max_chars));
    }

    public static String readDecimalString(CharacterIterator i, int max_chars) {
        char c;
        StringBuffer buf = new StringBuffer();
        if (StringUtil.peekAndEat(i, '-')) {
            buf.append('-');
        }
        for (int cntr = 0; cntr < max_chars && Character.isDigit(c = i.current()); ++cntr) {
            buf.append(c);
            i.next();
        }
        return buf.toString();
    }

    public static int readIntegerValue(CharacterIterator i) {
        char ch = i.current();
        if (ch == '-') {
            return StringUtil.readDecimalValue(i, 10);
        }
        if (ch == '0') {
            ch = i.next();
            if (ch == 'x' || ch == 'X') {
                i.next();
                return StringUtil.readHexValue(i, 8);
            }
            if (ch == 'b' || ch == 'B') {
                i.next();
                return StringUtil.readBinaryValue(i, 32);
            }
            return StringUtil.readOctalValue(i, 11);
        }
        return StringUtil.readDecimalValue(i, 10);
    }

    public static void skipWhiteSpace(CharacterIterator i) {
        char c;
        while ((c = i.current()) == ' ' || c == '\n' || c == '\t') {
            i.next();
        }
    }

    public static char peek(CharacterIterator i) {
        return i.current();
    }

    public static boolean peekAndEat(CharacterIterator i, char c) {
        char r = i.current();
        if (r == c) {
            i.next();
            return true;
        }
        return false;
    }

    public static boolean peekAndEat(CharacterIterator i, String s) {
        int ind = i.getIndex();
        for (int cntr = 0; cntr < s.length(); ++cntr) {
            if (i.current() != s.charAt(cntr)) {
                i.setIndex(ind);
                return false;
            }
            i.next();
        }
        return true;
    }

    public static void expectChar(CharacterIterator i, char c) throws Exception {
        char r = i.current();
        i.next();
        if (r != c) {
            Util.failure("parse error at " + i.getIndex() + ", expected character " + StringUtil.squote(c));
        }
    }

    public static void expectChars(CharacterIterator i, String s) throws Exception {
        for (int cntr = 0; cntr < s.length(); ++cntr) {
            StringUtil.expectChar(i, s.charAt(cntr));
        }
    }

    public static void expectKeyword(CharacterIterator i, String kw) {
        String str = StringUtil.readIdentifier(i);
        if (!str.equals(kw)) {
            Util.failure("parse error at " + i.getIndex() + ", expected keyword " + StringUtil.quote(kw));
        }
    }

    public static boolean isHex(String s) {
        if (s.length() < 2) {
            return false;
        }
        char c = s.charAt(1);
        return s.charAt(0) == '0' && (c == 'x' || c == 'X');
    }

    public static boolean isBin(String s) {
        if (s.length() < 2) {
            return false;
        }
        char c = s.charAt(1);
        return s.charAt(0) == '0' && (c == 'b' || c == 'B');
    }

    public static boolean isHexDigit(char c) {
        return CharUtil.isHexDigit(c);
    }

    public static int hexValueOf(char c) {
        return CharUtil.hexValueOf(c);
    }

    public static int octalValueOf(char c) {
        return CharUtil.octValueOf(c);
    }

    public static boolean isOctalDigit(char c) {
        return CharUtil.isOctDigit(c);
    }

    public static void justify(boolean right, StringBuffer buf, String s, int width) {
        int pad = width - s.length();
        if (right) {
            StringUtil.space(buf, pad);
            buf.append(s);
        } else {
            buf.append(s);
            StringUtil.space(buf, pad);
        }
    }

    public static void justify(boolean right, StringBuffer buf, long l, int width) {
        StringUtil.justify(right, buf, Long.toString(l), width);
    }

    public static void justify(boolean right, StringBuffer buf, float f, int width) {
        StringUtil.justify(right, buf, Float.toString(f), width);
    }

    public static String justify(boolean right, String s, int width) {
        if (width - s.length() <= 0) {
            return s;
        }
        StringBuffer buf = new StringBuffer(width);
        StringUtil.justify(right, buf, s, width);
        return buf.toString();
    }

    public static String justify(boolean right, long l, int width) {
        return StringUtil.justify(right, Long.toString(l), width);
    }

    public static String justify(boolean right, float f, int width) {
        return StringUtil.justify(right, Float.toString(f), width);
    }

    public static String leftJustify(long v, int width) {
        return StringUtil.justify(false, v, width);
    }

    public static String leftJustify(float v, int width) {
        return StringUtil.justify(false, v, width);
    }

    public static String leftJustify(String s, int width) {
        return StringUtil.justify(false, s, width);
    }

    public static String rightJustify(long v, int width) {
        return StringUtil.justify(true, v, width);
    }

    public static String rightJustify(float v, int width) {
        return StringUtil.justify(true, v, width);
    }

    public static String rightJustify(String s, int width) {
        return StringUtil.justify(true, s, width);
    }

    public static String toHex(long value, int width) {
        return StringUtil.convertToHex(value, width, 0, new char[width], CharUtil.HEX_CHARS);
    }

    public static String toLowHex(long value, int width) {
        return StringUtil.convertToHex(value, width, 0, new char[width], CharUtil.LOW_HEX_CHARS);
    }

    private static String convertToHex(long value, int width, int start, char[] result, char[] hexChars) {
        if (value > 1L << width * 4) {
            StringBuffer buf = new StringBuffer();
            for (int cntr = 0; cntr < start; ++cntr) {
                buf.append(result[cntr]);
            }
            buf.append(Long.toHexString(value).toUpperCase());
            return buf.toString();
        }
        int i = start + width - 1;
        for (int cntr = 0; cntr < width; ++cntr) {
            result[i - cntr] = hexChars[(int)(value >> cntr * 4) & 0xF];
        }
        return new String(result);
    }

    public static String to0xHex(long value, int width) {
        char[] result = new char[width + 2];
        result[0] = 48;
        result[1] = 120;
        return StringUtil.convertToHex(value, width, 2, result, CharUtil.HEX_CHARS);
    }

    public static String toBin(long value, int width) {
        char[] result = new char[width];
        for (int cntr = 0; cntr < width; ++cntr) {
            result[width - cntr - 1] = (value & (long)(1 << cntr)) == 0L ? 48 : 49;
        }
        return new String(result);
    }

    public static void toHex(StringBuffer buf, long value, int width) {
        if (value > 1L << width * 4) {
            buf.append(Long.toHexString(value).toUpperCase());
            return;
        }
        for (int cntr = width - 1; cntr >= 0; --cntr) {
            buf.append(CharUtil.HEX_CHARS[(int)(value >> cntr * 4) & 0xF]);
        }
    }

    public static String splice(String[] a, String[] b) {
        int cntr;
        StringBuffer buf = new StringBuffer();
        for (cntr = 0; cntr < a.length; ++cntr) {
            buf.append(a[cntr]);
            if (cntr >= b.length) continue;
            buf.append(b[cntr]);
        }
        while (cntr < b.length) {
            buf.append(b[cntr]);
            ++cntr;
        }
        return buf.toString();
    }

    public static String quote(Object s) {
        return QUOTE + s + QUOTE;
    }

    public static String squote(char c) {
        return SQUOTE + c + SQUOTE;
    }

    public static String embed(Object s) {
        return LPAREN + s + RPAREN;
    }

    public static String embed(Object lead, Object arg) {
        return lead + LPAREN + arg + RPAREN;
    }

    public static String embed(Object lead, Object arg1, Object arg2) {
        return lead + LPAREN + arg1 + COMMA_SPACE + arg2 + RPAREN;
    }

    public static String embed(Object lead, Object arg1, Object arg2, Object arg3) {
        return lead + LPAREN + arg1 + COMMA_SPACE + arg2 + COMMA_SPACE + arg3 + RPAREN;
    }

    public static String embed(Object lead, Object arg1, Object arg2, Object arg3, Object arg4) {
        return lead + LPAREN + arg1 + COMMA_SPACE + arg2 + COMMA_SPACE + arg3 + COMMA_SPACE + arg4 + RPAREN;
    }

    public static String commalist(List l) {
        StringBuffer buf = new StringBuffer();
        StringUtil.commalist(l, buf);
        return buf.toString();
    }

    public static void commalist(List l, StringBuffer buf) {
        Iterator i = l.iterator();
        while (i.hasNext()) {
            buf.append(i.next().toString());
            if (!i.hasNext()) continue;
            buf.append(COMMA_SPACE);
        }
    }

    public static String commalist(Object[] o) {
        StringBuffer buf = new StringBuffer();
        StringUtil.commalist(o, buf);
        return buf.toString();
    }

    public static void commalist(Object[] o, StringBuffer buf) {
        for (int cntr = 0; cntr < o.length; ++cntr) {
            if (cntr > 0) {
                buf.append(COMMA_SPACE);
            }
            buf.append(o[cntr].toString());
        }
    }

    public static void commalist(Iterator i, StringBuffer buf) {
        int cntr = 0;
        while (i.hasNext()) {
            if (cntr > 0) {
                buf.append(COMMA_SPACE);
            }
            buf.append(i.next().toString());
            ++cntr;
        }
    }

    public static String linelist(List l) {
        StringBuffer buf = new StringBuffer();
        StringUtil.linelist(buf, l);
        return buf.toString();
    }

    public static void linelist(StringBuffer buf, List l) {
        Iterator i = l.iterator();
        while (i.hasNext()) {
            buf.append(i.next().toString());
            buf.append('\n');
        }
    }

    public static String commalist(Object o1, Object o2) {
        return o1 + COMMA + o2;
    }

    public static String commalist(Object o1, Object o2, Object o3) {
        return o1 + COMMA + o2 + COMMA + o3;
    }

    public static String commalist(Object o1, Object o2, Object o3, Object o4) {
        return o1 + COMMA + o2 + COMMA + o3 + COMMA + o4;
    }

    public static String interval(int low, int high) {
        return "[" + low + COMMA_SPACE + high + ']';
    }

    public static char alpha(int num) {
        return (char)(97 + num - 1);
    }

    public static String qembed(String s1, String s2, String s3) {
        return s1 + ' ' + StringUtil.quote(s2) + ' ' + s3;
    }

    public static int evaluateIntegerLiteral(String val) {
        return StringUtil.readIntegerValue(new StringCharacterIterator(val));
    }

    public static String evaluateStringLiteral(String literal) throws Exception {
        StringBuffer buffer = new StringBuffer(literal.length());
        StringCharacterIterator i = new StringCharacterIterator(literal);
        StringUtil.expectChar(i, '\"');
        while (!StringUtil.peekAndEat((CharacterIterator)i, '\"')) {
            char c = i.current();
            i.next();
            if (c == '\uffff') break;
            if (c == '\\') {
                c = StringUtil.escapeChar(i);
            }
            buffer.append(c);
        }
        StringUtil.expectChar(i, '\uffff');
        return buffer.toString();
    }

    public static char evaluateCharLiteral(String literal) throws Exception {
        char ch;
        StringCharacterIterator i = new StringCharacterIterator(literal);
        StringUtil.expectChar(i, '\'');
        if (StringUtil.peekAndEat((CharacterIterator)i, '\\')) {
            ch = StringUtil.escapeChar(i);
        } else {
            ch = i.current();
            i.next();
        }
        StringUtil.expectChar(i, '\'');
        StringUtil.expectChar(i, '\uffff');
        return ch;
    }

    private static char escapeChar(CharacterIterator i) {
        char c = i.current();
        switch (c) {
            case 'f': {
                i.next();
                return '\f';
            }
            case 'b': {
                i.next();
                return '\b';
            }
            case 'n': {
                i.next();
                return '\n';
            }
            case 'r': {
                i.next();
                return '\r';
            }
            case '\\': {
                i.next();
                return '\\';
            }
            case '\'': {
                i.next();
                return '\'';
            }
            case '\"': {
                i.next();
                return '\"';
            }
            case 't': {
                i.next();
                return '\t';
            }
            case 'x': {
                return (char)StringUtil.readHexValue(i, 4);
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                return (char)StringUtil.readOctalValue(i, 3);
            }
        }
        return c;
    }

    private static IllegalArgumentException invalidCharLiteral(String lit) {
        return new IllegalArgumentException("Invalid character literal: " + lit);
    }

    public static String trimquotes(String s) {
        if (s.length() == 0) {
            return s;
        }
        int start = 0;
        int end = s.length();
        if (s.charAt(start) == '\"') {
            ++start;
        }
        if (s.charAt(end - 1) == '\"') {
            --end;
        }
        if (start < end) {
            return s.substring(start, end);
        }
        return "";
    }

    public static String formatParagraphs(String s, int leftJust, int indent, int width) {
        int len = s.length();
        int consumed = (indent += leftJust) + leftJust;
        String indstr = StringUtil.space(indent);
        String ljstr = StringUtil.space(leftJust);
        StringBuffer buf = new StringBuffer(s.length() + 50);
        buf.append(indstr);
        int lastSp = -1;
        for (int cntr = 0; cntr < len; ++cntr) {
            char c = s.charAt(cntr);
            if (c == '\n') {
                buf.append('\n');
                consumed = indent;
                buf.append(indstr);
                continue;
            }
            if (Character.isWhitespace(c)) {
                lastSp = buf.length();
            }
            buf.append(c);
            if (++consumed <= width || lastSp < 0) continue;
            buf.setCharAt(lastSp, '\n');
            buf.insert(lastSp + 1, ljstr);
            consumed = buf.length() - lastSp + leftJust - 1;
        }
        return buf.toString();
    }

    public static List trimLines(String s, int indent, int width) {
        LinkedList<String> list = new LinkedList<String>();
        int len = s.length();
        int consumed = indent;
        String indstr = StringUtil.space(indent);
        StringBuffer buf = new StringBuffer(s.length());
        buf.append(indstr);
        int lastSp = -1;
        for (int cntr = 0; cntr < len; ++cntr) {
            char c = s.charAt(cntr);
            if (c == '\n') {
                buf = StringUtil.newBuffer(indstr, buf, list);
                consumed = buf.length();
                continue;
            }
            if (Character.isWhitespace(c)) {
                lastSp = consumed;
            }
            buf.append(c);
            if (++consumed <= width || lastSp < 0) continue;
            String leftover = buf.substring(lastSp + 1);
            buf.setLength(lastSp);
            buf = StringUtil.newBuffer(leftover, buf, list);
            consumed = buf.length();
        }
        if (buf.length() > 0) {
            list.add(buf.toString());
        }
        return list;
    }

    static StringBuffer newBuffer(String n, StringBuffer old, List strs) {
        strs.add(old.toString());
        return new StringBuffer(n);
    }

    public static String dup(char c, int len) {
        StringBuffer buf = new StringBuffer(len);
        for (int cntr = 0; cntr < len; ++cntr) {
            buf.append(c);
        }
        return buf.toString();
    }

    public static String space(int len) {
        if (len <= 0) {
            return "";
        }
        if (len < spacers.length) {
            return spacers[len];
        }
        return StringUtil.dup(' ', len);
    }

    public static void space(StringBuffer buf, int len) {
        while (len-- > 0) {
            buf.append(' ');
        }
    }

    public static String toFixedFloat(float fval, int places) {
        if (Float.isInfinite(fval)) {
            return "(inf)";
        }
        if (Float.isNaN(fval)) {
            return "(NaN)";
        }
        StringBuffer buf = new StringBuffer(places + 5);
        long val = (long)fval;
        buf.append(val);
        float fract = fval >= 0.0f ? fval - (float)val : (float)val - fval;
        StringUtil.appendFract(buf, fract, places);
        return buf.toString();
    }

    public static String toDecimal(long val, int places) {
        StringBuffer buf = new StringBuffer(10 + places);
        while (places > 0) {
            buf.append(val % 10L);
            val /= 10L;
            if (--places != 0) continue;
            buf.append('.');
        }
        buf.reverse();
        return val + buf.toString();
    }

    public static String toMultirepString(int value, int bits) {
        StringBuffer buf = new StringBuffer(bits * 3 + 8);
        buf.append("0x");
        int hexdigs = (bits + 3) / 4;
        StringUtil.toHex(buf, value, hexdigs);
        buf.append(" [");
        for (int bit = bits - 1; bit >= 0; --bit) {
            buf.append(Arithmetic.getBit(value, bit) ? (char)'1' : '0');
        }
        buf.append("] (");
        buf.append(value);
        buf.append(") ");
        if (bits < 9) {
            StringUtil.appendChar(value, buf);
        }
        return buf.toString();
    }

    private static void appendChar(int value, StringBuffer buf) {
        switch (value) {
            case 10: {
                buf.append("'\\n'");
                break;
            }
            case 13: {
                buf.append("'\\r'");
                break;
            }
            case 8: {
                buf.append("'\\b'");
                break;
            }
            case 9: {
                buf.append("'\\t'");
                break;
            }
            default: {
                if (value < 32) break;
                buf.append(SQUOTE);
                buf.append((char)value);
                buf.append(SQUOTE);
            }
        }
    }

    public static char toBit(boolean f) {
        return f ? (char)'1' : '0';
    }

    public static void appendFract(StringBuffer buf, double val, int digits) {
        int radix = 10;
        for (int cntr = 0; cntr < digits; ++cntr) {
            if (cntr == 0) {
                buf.append('.');
            }
            int digit = (int)(val * (double)radix) % 10;
            buf.append((char)(digit + 48));
            radix *= 10;
        }
    }

    public static String stringReplace(String template, Properties p, Object o1) {
        p.setProperty("1", o1.toString());
        return StringUtil.stringReplace(template, p);
    }

    public static String stringReplace(String template, Properties p, Object[] strs) {
        for (int cntr = 0; cntr < strs.length; ++cntr) {
            p.setProperty(String.valueOf(cntr + 1), strs[cntr].toString());
        }
        return StringUtil.stringReplace(template, p);
    }

    public static String stringReplace(String template, Properties p, String[] strs) {
        for (int cntr = 0; cntr < strs.length; ++cntr) {
            p.setProperty(String.valueOf(cntr + 1), strs[cntr]);
        }
        return StringUtil.stringReplace(template, p);
    }

    public static String stringReplace(String template, Properties p, Object o1, Object o2) {
        p.setProperty("1", o1.toString());
        p.setProperty("2", o2.toString());
        return StringUtil.stringReplace(template, p);
    }

    public static String stringReplace(String template, Properties p, Object o1, Object o2, Object o3) {
        p.setProperty("1", o1.toString());
        p.setProperty("2", o2.toString());
        p.setProperty("3", o3.toString());
        return StringUtil.stringReplace(template, p);
    }

    public static String stringReplace(String template, Properties p) {
        int max = template.length();
        StringBuffer buf = new StringBuffer(max);
        for (int pos = 0; pos < max; ++pos) {
            char ch = template.charAt(pos);
            if (ch == '$') {
                pos = StringUtil.replaceVar(pos, max, template, buf, p);
                continue;
            }
            if (ch == '%') {
                pos = StringUtil.replaceVarQuote(pos, max, template, buf, p);
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    private static int replaceVar(int pos, int max, String template, StringBuffer buf, Properties p) {
        StringBuffer var = new StringBuffer(10);
        pos = StringUtil.scanAhead(pos, '$', max, template, buf, var);
        String result = StringUtil.getProperty(var, p);
        buf.append(result);
        return pos;
    }

    private static int scanAhead(int pos, char ch, int max, String template, StringBuffer buf, StringBuffer var) {
        ++pos;
        while (pos < max) {
            char vch = template.charAt(pos);
            if (!Character.isLetterOrDigit(vch)) {
                --pos;
                break;
            }
            if (vch == ch) {
                buf.append(ch);
                break;
            }
            var.append(vch);
            ++pos;
        }
        return pos;
    }

    private static String getProperty(StringBuffer var, Properties p) {
        String varname = var.toString();
        String result = p.getProperty(varname);
        if (result == null) {
            throw Util.failure("stringReplace(): unknown variable " + StringUtil.quote(varname));
        }
        return result;
    }

    private static int replaceVarQuote(int pos, int max, String template, StringBuffer buf, Properties p) {
        StringBuffer var = new StringBuffer(10);
        pos = StringUtil.scanAhead(pos, '%', max, template, buf, var);
        String result = StringUtil.getProperty(var, p);
        buf.append('\"');
        buf.append(result);
        buf.append('\"');
        return pos;
    }

    public static char[] getStringChars(String str) {
        char[] val = new char[str.length()];
        str.getChars(0, val.length, val, 0);
        return val;
    }

    public static List toList(String val) {
        LinkedList<String> list = new LinkedList<String>();
        if ("".equals(val)) {
            return list;
        }
        StringCharacterIterator i = new StringCharacterIterator(val);
        StringBuffer buf = new StringBuffer(32);
        while (i.current() != '\uffff') {
            if (i.current() == ',') {
                list.add(buf.toString().trim());
                buf = new StringBuffer(32);
            } else {
                buf.append(i.current());
            }
            i.next();
        }
        list.add(buf.toString().trim());
        return list;
    }

    public static String getShortName(Class clazz) {
        String nm = clazz.getName();
        int dollar = nm.lastIndexOf(36);
        int dot = nm.lastIndexOf(46);
        if (dot > 0 || dollar > 0) {
            nm = dot > dollar ? nm.substring(dot + 1, nm.length()) : nm.substring(dollar + 1, nm.length());
        }
        return nm;
    }
}

