/*
 * Decompiled with CFR 0.152.
 */
package cck.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;

public class SectionFile
extends FileOutputStream {
    private final BufferedReader template;
    private final String file_name;
    private final String start_delimiter;
    private final String end_delimiter;
    private boolean header_done;

    public SectionFile(String fname, String sect) throws FileNotFoundException {
        super(new File(fname + ".new"));
        this.file_name = fname;
        this.template = new BufferedReader(new FileReader(fname));
        this.start_delimiter = "//--BEGIN " + sect + "--";
        this.end_delimiter = "//--END " + sect + "--";
    }

    public void write(byte[] b) throws IOException {
        this.readHeader();
        super.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.readHeader();
        super.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.readHeader();
        super.write(b);
    }

    public void writeLine(String s) throws IOException {
        this.readHeader();
        super.write(s.getBytes());
        super.write(10);
    }

    public void close() throws IOException {
        this.readHeader();
        this.discardSection();
        this.readFooter();
        this.template.close();
        super.close();
        File old = new File(this.file_name);
        old.delete();
        new File(this.file_name + ".new").renameTo(old);
    }

    private void readHeader() throws IOException {
        String line;
        if (this.header_done) {
            return;
        }
        do {
            if ((line = this.template.readLine()) == null) {
                throw new IOException("no section delimiter found");
            }
            super.write(line.getBytes());
            super.write(10);
        } while (!line.equals(this.start_delimiter));
        this.header_done = true;
    }

    private void discardSection() throws IOException {
        String line;
        while ((line = this.template.readLine()) != null) {
            if (!line.equals(this.end_delimiter)) continue;
            super.write(line.getBytes());
            super.write(10);
            break;
        }
    }

    private void readFooter() throws IOException {
        String line;
        while ((line = this.template.readLine()) != null) {
            super.write(line.getBytes());
            super.write(10);
        }
    }
}

