/*
 * Decompiled with CFR 0.152.
 */
package cck.text;

import java.io.PrintStream;

public class Printer {
    private final PrintStream o;
    private boolean begLine;
    private int listdepth;
    private boolean first;
    private boolean nlcomma;
    private int indent;
    public static final Printer STDOUT = new Printer(System.out);
    public static final Printer STDERR = new Printer(System.out);

    public Printer(PrintStream o) {
        this.o = o;
        this.begLine = true;
    }

    public void println(String s) {
        this.spaces();
        if (this.listdepth > 0 && !this.first) {
            this.o.print(", ");
        }
        this.first = false;
        this.o.println(s);
        this.begLine = true;
        this.first = false;
    }

    public void print(String s) {
        this.spaces();
        if (this.listdepth > 0 && !this.first) {
            this.o.print(", ");
        }
        this.first = false;
        this.o.print(s);
    }

    public void nextln() {
        if (!this.begLine) {
            this.o.print("\n");
            this.begLine = true;
        }
    }

    public void indent() {
        ++this.indent;
    }

    public void spaces() {
        if (this.begLine) {
            for (int cntr = 0; cntr < this.indent; ++cntr) {
                this.o.print("    ");
            }
            this.begLine = false;
        }
    }

    public void unindent() {
        --this.indent;
        if (this.indent < 0) {
            this.indent = 0;
        }
    }

    public void startblock() {
        this.println("{");
        this.indent();
    }

    public void startblock(String name) {
        this.println(name + " {");
        this.indent();
    }

    public void endblock() {
        this.unindent();
        this.println("}");
    }

    public void endblock(String s) {
        this.unindent();
        this.println('}' + s);
    }

    public void close() {
        this.o.close();
    }

    public void beginList(String beg) {
        this.print(beg);
        ++this.listdepth;
        this.first = true;
    }

    public void beginList() {
        ++this.listdepth;
        this.first = true;
    }

    public void endList(String end) {
        --this.listdepth;
        if (this.listdepth < 0) {
            this.listdepth = 0;
        }
        this.print(end);
    }

    public void endListln(String end) {
        --this.listdepth;
        if (this.listdepth < 0) {
            this.listdepth = 0;
        }
        this.println(end);
    }

    public void endList() {
        --this.listdepth;
        if (this.listdepth < 0) {
            this.listdepth = 0;
        }
    }

    public void endListln() {
        --this.listdepth;
        if (this.listdepth < 0) {
            this.listdepth = 0;
        }
        this.nextln();
    }
}

