/*
 * Decompiled with CFR 0.152.
 */
package cck.text;

import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;
import java.util.Arrays;

public class Columnifier {
    protected int margin;
    protected int[] color;
    protected int[] width;
    protected boolean[] right;

    public Columnifier() {
        this.width = new int[0];
        this.color = new int[0];
        this.right = new boolean[0];
    }

    public Columnifier(int[] w) {
        this.width = w;
        this.right = new boolean[w.length];
        this.color = new int[w.length];
        Arrays.fill(this.color, -1);
    }

    public Columnifier(int[] c, int[] w) {
        assert (c.length == w.length);
        this.width = w;
        this.right = new boolean[w.length];
        this.color = c;
    }

    public Columnifier(int[] c, int[] w, boolean[] r) {
        if (c == null) {
            c = new int[w.length];
            Arrays.fill(c, -1);
        }
        assert (c.length == w.length && w.length == r.length);
        this.width = w;
        this.right = r;
        this.color = c;
    }

    public void setLeftMargin(int l) {
        this.margin = l;
    }

    public void addColumn(int c, int w, boolean r) {
        int pl = this.color.length;
        this.color = new int[pl + 1];
        System.arraycopy(this.color, 0, this.color, 0, pl);
        this.width = new int[pl + 1];
        System.arraycopy(this.width, 0, this.width, 0, pl);
        this.right = new boolean[pl + 1];
        System.arraycopy(this.right, 0, this.right, 0, pl);
        this.color[pl] = c;
        this.width[pl] = w;
        this.right[pl] = r;
    }

    public void println(String[] str) {
        assert (str.length == this.width.length);
        Terminal.print(StringUtil.space(this.margin));
        for (int cntr = 0; cntr < str.length; ++cntr) {
            int w;
            String j;
            String s = str[cntr];
            int sw = s.length();
            String string = j = sw < (w = this.width[cntr]) ? StringUtil.space(w - sw) : "";
            if (this.right[cntr]) {
                Terminal.print(j);
                Terminal.print(this.color[cntr], s);
                continue;
            }
            Terminal.print(this.color[cntr], s);
            Terminal.print(j);
        }
        Terminal.nextln();
    }

    public void printTitle(int color, String[] str) {
        assert (str.length == this.width.length);
        Terminal.print(StringUtil.space(this.margin));
        for (int cntr = 0; cntr < str.length; ++cntr) {
            int w;
            String j;
            String s = str[cntr];
            int sw = s.length();
            String string = j = sw < (w = this.width[cntr]) ? StringUtil.space(w - sw) : "";
            if (this.right[cntr]) {
                Terminal.print(j);
                Terminal.print(color, s);
                continue;
            }
            Terminal.print(color, s);
            Terminal.print(j);
        }
        Terminal.nextln();
        TermUtil.printThinSeparator();
    }
}

