/*
 * Decompiled with CFR 0.152.
 */
package cck.test;

import cck.parser.SourceError;
import cck.test.TestEngine;
import cck.text.Terminal;
import cck.util.Util;

public abstract class TestResult {
    public static final int SUCCESS = 0;
    public static final int FAILURE = 1;
    public static final int EXCEPTION = 2;
    public static final int INTERNAL = 3;
    public static final int MALFORMED = 4;
    public static final int NONTERM = 5;
    public static final int MAX_CODE = 6;
    public final int code;

    public TestResult(int c) {
        this.code = c;
    }

    public abstract void shortReport();

    public boolean isSuccess() {
        return this.code == 0;
    }

    public int getColor() {
        return TestResult.getColor(this.code);
    }

    static int getColor(int code) {
        switch (code) {
            case 0: {
                return 2;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 11;
            }
            case 5: {
                return 11;
            }
            case 4: {
                return 6;
            }
        }
        return 1;
    }

    public void longReport() {
        this.shortReport();
    }

    public static class Malformed
    extends TestResult {
        public final String error;

        public Malformed(String e) {
            super(4);
            this.error = e;
        }

        public void shortReport() {
            Terminal.print("malformed testcase: " + this.error);
        }
    }

    public static class UnexpectedException
    extends TestFailure {
        public final Throwable encountered;

        public UnexpectedException(Throwable e) {
            super("encountered unexpected exception " + e.getClass(), e);
            this.encountered = e;
        }

        public UnexpectedException(String msg, Throwable e) {
            super(msg + e.getClass(), e);
            this.encountered = e;
        }

        public void longReport() {
            Terminal.println("encountered unexpected exception");
            this.encountered.printStackTrace();
            Throwable cause = this.encountered.getCause();
            if (cause != null) {
                Terminal.printRed("Caused by");
                Terminal.print(": ");
                cause.printStackTrace();
            }
        }
    }

    public static class NonTermError
    extends TestFailure {
        public final TestEngine.NonTermination encountered;

        public NonTermError(TestEngine.NonTermination e) {
            super("Test did not terminate after " + e.milliseconds + " ms", e);
            this.encountered = e;
        }

        public void longReport() {
            Terminal.print("test did not terminate\n");
            this.encountered.report();
        }
    }

    public static class InternalError
    extends TestFailure {
        public final Util.InternalError encountered;

        public InternalError(Util.InternalError e) {
            super("encountered internal error: " + e.getMessage(), e);
            this.encountered = e;
        }

        public void longReport() {
            Terminal.print("encountered internal error\n");
            this.encountered.report();
        }
    }

    public static class ExpectedError
    extends TestFailure {
        public final String expected;

        public ExpectedError(String e) {
            super("expected error " + e + ", but passed");
            this.expected = e;
        }
    }

    public static class ExpectedPass
    extends TestFailure {
        public final SourceError encountered;

        public ExpectedPass(SourceError e) {
            super("expected pass, but received error " + e.getErrorType(), e);
            this.encountered = e;
        }

        public void longReport() {
            Terminal.println("expected pass, but received error");
            this.encountered.report();
        }
    }

    public static class IncorrectError
    extends TestFailure {
        public final String expected;
        public final SourceError encountered;

        public IncorrectError(String ex, SourceError ce) {
            super("expected error " + ex + ", but received " + ce.getErrorType(), ce);
            this.expected = ex;
            this.encountered = ce;
        }

        public void longReport() {
            Terminal.println("expected error " + this.expected + " but received");
            this.encountered.report();
        }
    }

    public static class TestFailure
    extends TestResult {
        public final String message;
        public final Throwable thrown;

        public TestFailure() {
            super(1);
            this.message = "failed";
            this.thrown = null;
        }

        public TestFailure(String r) {
            super(1);
            this.message = r;
            this.thrown = null;
        }

        public TestFailure(String r, Throwable t) {
            super(1);
            this.message = r;
            this.thrown = t;
        }

        public void shortReport() {
            Terminal.print(this.message);
        }
    }

    public static class TestSuccess
    extends TestResult {
        public TestSuccess() {
            super(0);
        }

        public void shortReport() {
            Terminal.print("passed");
        }
    }
}

