/*
 * Decompiled with CFR 0.152.
 */
package cck.test;

import cck.test.TestCase;
import cck.test.TestResult;
import cck.text.Status;
import cck.text.Terminal;
import cck.util.ClassMap;
import cck.util.TimeUtil;
import cck.util.Util;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class TestEngine {
    public static int MAXIMUM_TEST_MS = 5000;
    public static boolean LONG_REPORT;
    public static boolean PROGRESS_REPORT;
    public static boolean STATISTICS;
    public static int THREADS;
    public static int VERBOSE;
    public List[] results;
    public List successes;
    private String[] testNames;
    private int numTests;
    private int currentTest;
    private int finishedTests;
    private final ClassMap harnessMap;

    public TestEngine(ClassMap hm) {
        this.harnessMap = hm;
    }

    public boolean runTests(String[] fnames) throws IOException {
        long time = System.currentTimeMillis();
        this.initTests(fnames);
        this.runAllTests();
        time = System.currentTimeMillis() - time;
        this.reportFailures();
        this.reportSuccesses(time);
        this.reportStatistics(this.results);
        return this.successes.size() == this.numTests;
    }

    private void reportFailures() {
        if (VERBOSE > 0) {
            TestEngine.report("Internal errors", this.results, 3, this.numTests);
            TestEngine.report("Unexpected exceptions", this.results, 2, this.numTests);
            TestEngine.report("Failed", this.results, 1, this.numTests);
            TestEngine.report("Malformed test cases", this.results, 4, this.numTests);
            TestEngine.report("Nonterminating cases", this.results, 5, this.numTests);
        }
    }

    private void reportSuccesses(long time) {
        if (VERBOSE > 0) {
            Terminal.printBrightGreen("Passed");
            Terminal.print(": " + this.successes.size());
            Terminal.print(" of " + this.numTests);
            Terminal.print(" in " + TimeUtil.milliToSecs(time) + " seconds");
            Terminal.nextln();
        }
    }

    private void initTests(String[] fnames) {
        Status.ENABLED = false;
        this.testNames = fnames;
        this.numTests = fnames.length;
        this.currentTest = 0;
        this.results = new LinkedList[6];
        for (int cntr = 0; cntr < 6; ++cntr) {
            this.results[cntr] = new LinkedList();
        }
        this.successes = this.results[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runAllTests() {
        try {
            WorkThread[] threads = new WorkThread[THREADS];
            for (int cntr = 0; cntr < THREADS; ++cntr) {
                WorkThread thread;
                threads[cntr] = thread = new WorkThread();
                thread.start();
            }
            while (this.finishedTests < this.numTests) {
                long now = System.currentTimeMillis();
                for (int cntr = 0; cntr < THREADS; ++cntr) {
                    WorkThread thread = threads[cntr];
                    if (!thread.intest || now - thread.test_began <= (long)MAXIMUM_TEST_MS) continue;
                    thread.interrupt();
                    thread.stop(new NonTermination(now - thread.test_began));
                }
                TestEngine testEngine = this;
                synchronized (testEngine) {
                    this.wait(1000L);
                }
            }
            return;
        }
        catch (InterruptedException e) {
            throw Util.unexpected(e);
        }
    }

    private void runTest(int num) {
        try {
            TestCase tc = this.runTest(this.testNames[num]);
        }
        catch (IOException e) {
            throw Util.unexpected(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int nextTest() {
        TestEngine testEngine = this;
        synchronized (testEngine) {
            if (this.currentTest < this.numTests) {
                return this.currentTest++;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishTest(TestCase tc) {
        TestEngine testEngine = this;
        synchronized (testEngine) {
            this.results[tc.result.code].add(tc);
            ++this.finishedTests;
            this.reportVerbose(tc);
            if (this.finishedTests >= this.numTests) {
                this.notifyAll();
            }
        }
    }

    private void reportStatistics(List[] tests) {
        if (STATISTICS) {
            for (int cntr = 0; cntr < tests.length; ++cntr) {
                for (TestCase tc : tests[cntr]) {
                    tc.reportStatistics();
                }
            }
        }
    }

    private static void report(String c, List[] lists, int w, int total) {
        List list = lists[w];
        if (list.isEmpty()) {
            return;
        }
        Terminal.print(TestResult.getColor(w), c);
        Terminal.println(": " + list.size() + " of " + total);
        for (TestCase tc : list) {
            TestEngine.report(tc.getFileName(), tc.result);
        }
    }

    private static void report(String fname, TestResult result) {
        Terminal.print("  ");
        Terminal.printRed(fname);
        Terminal.print(": ");
        if (LONG_REPORT) {
            result.longReport();
        } else {
            result.shortReport();
        }
        Terminal.print("\n");
    }

    private TestCase runTest(String fname) throws IOException {
        TestCase tc = this.readTestCase(fname);
        Throwable exception = null;
        try {
            this.beginVerbose(fname);
            tc.run();
        }
        catch (Throwable t) {
            exception = t;
        }
        try {
            tc.result = tc.match(exception);
        }
        catch (Throwable t) {
            tc.result = new TestResult.UnexpectedException("exception in match routine: ", t);
        }
        this.finishTest(tc);
        return tc;
    }

    private void beginVerbose(String fname) {
        if (VERBOSE == 3) {
            Terminal.print("Running " + fname + "...");
            Terminal.flush();
        }
    }

    private void reportVerbose(TestCase tc) {
        if (VERBOSE == 3) {
            if (tc.result.isSuccess()) {
                Terminal.printGreen("passed");
            } else {
                Terminal.printRed("failed");
            }
            Terminal.nextln();
        } else if (VERBOSE == 2) {
            if (tc.result.isSuccess()) {
                Terminal.printGreen("o");
            } else {
                Terminal.printRed("X");
            }
            if (this.finishedTests % 50 == 0 || this.finishedTests >= this.numTests) {
                Terminal.print(" " + this.finishedTests + " of " + this.numTests);
                Terminal.nextln();
            } else if (this.finishedTests % 10 == 0) {
                Terminal.print(" ");
            }
            Terminal.flush();
        }
    }

    private TestCase readTestCase(String fname) throws IOException {
        int index2;
        int index;
        String buffer;
        BufferedReader r = new BufferedReader(new FileReader(fname));
        Properties vars = new Properties();
        while ((buffer = r.readLine()) != null && (index = buffer.indexOf(64)) >= 0 && (index2 = buffer.indexOf(58)) >= 0) {
            String var = buffer.substring(index + 1, index2).trim();
            String val = buffer.substring(index2 + 1).trim();
            vars.put(var, val);
        }
        r.close();
        String expect = vars.getProperty("Result");
        String hname = vars.getProperty("Harness");
        if (expect == null) {
            return new TestCase.Malformed(fname, "no result specified");
        }
        if (hname == null) {
            return new TestCase.Malformed(fname, "no test harness specified");
        }
        try {
            Harness harness = (Harness)this.harnessMap.getObjectOfClass(hname);
            return harness.newTestCase(fname, vars);
        }
        catch (Throwable t) {
            return new TestCase.InitFailure(fname, t);
        }
    }

    static {
        THREADS = 1;
        VERBOSE = 1;
    }

    protected class WorkThread
    extends Thread {
        volatile boolean intest;
        volatile long test_began;

        protected WorkThread() {
        }

        public void run() {
            int num = TestEngine.this.nextTest();
            while (num >= 0) {
                this.test_began = System.currentTimeMillis();
                this.intest = true;
                TestEngine.this.runTest(num);
                this.intest = false;
                num = TestEngine.this.nextTest();
            }
        }
    }

    public class NonTermination
    extends Util.Error {
        public long milliseconds;

        public NonTermination(long ms) {
            super("Nontermination Error", "test did not terminate after " + ms + " ms");
            this.milliseconds = ms;
        }
    }

    public static interface Harness {
        public TestCase newTestCase(String var1, Properties var2) throws Exception;
    }
}

