/*
 * Decompiled with CFR 0.152.
 */
package cck.test;

import cck.parser.SourceError;
import cck.test.TestEngine;
import cck.test.TestResult;
import cck.text.StringUtil;
import cck.util.Util;
import java.util.Properties;

public abstract class TestCase {
    protected final String filename;
    protected final Properties properties;
    protected TestResult result;

    public TestCase(String fname, Properties props) {
        this.filename = fname;
        this.properties = props;
    }

    public String getFileName() {
        return this.filename;
    }

    public abstract void run() throws Exception;

    public TestResult match(Throwable t) {
        if (t == null) {
            return new TestResult.TestSuccess();
        }
        if (t instanceof TestEngine.NonTermination) {
            return new TestResult.NonTermError((TestEngine.NonTermination)t);
        }
        if (t instanceof Util.InternalError) {
            return new TestResult.InternalError((Util.InternalError)t);
        }
        return new TestResult.UnexpectedException(t);
    }

    protected String expectProperty(String prop) {
        String value = this.properties.getProperty(prop);
        if (value == null) {
            Util.userError("Property " + StringUtil.quote(prop) + " not found in testcase");
        }
        return this.trimString(value);
    }

    protected String trimString(String str) {
        return StringUtil.trimquotes(str.trim());
    }

    public void reportStatistics() {
    }

    public static class InitFailure
    extends TestCase {
        final Throwable thrown;

        public InitFailure(String fname, Throwable t) {
            super(fname, null);
            this.thrown = t;
        }

        public void run() {
        }

        public TestResult match(Throwable t) {
            return new TestResult.Malformed(this.thrown.toString());
        }
    }

    public static class Malformed
    extends TestCase {
        final String error;

        public Malformed(String fname, String e) {
            super(fname, null);
            this.error = e;
        }

        public void run() {
        }

        public TestResult match(Throwable t) {
            return new TestResult.Malformed(this.error);
        }
    }

    public static abstract class ExpectSourceError
    extends TestCase {
        protected boolean shouldPass;
        protected String error;

        public ExpectSourceError(String fname, Properties props) {
            super(fname, props);
            String result = StringUtil.trimquotes(props.getProperty("Result"));
            if ("PASS".equals(result)) {
                this.shouldPass = true;
            } else {
                int i = result.indexOf(64);
                this.error = i >= 0 ? result.substring(0, i).trim() : result;
            }
        }

        public TestResult match(Throwable t) {
            return this.shouldPass ? this.expectPass(t) : this.expectError(t);
        }

        protected TestResult expectPass(Throwable t) {
            if (t == null) {
                return this.checkPass();
            }
            return this.checkError(t);
        }

        protected TestResult expectError(Throwable t) {
            if (t == null) {
                return new TestResult.ExpectedError(this.error);
            }
            return this.matchError(t);
        }

        protected TestResult checkPass() {
            return new TestResult.TestSuccess();
        }

        protected TestResult checkError(Throwable t) {
            if (t instanceof SourceError) {
                return new TestResult.ExpectedPass((SourceError)t);
            }
            return super.match(t);
        }

        protected TestResult matchError(Throwable t) {
            if (t instanceof SourceError) {
                SourceError ce = (SourceError)t;
                if (ce.getErrorType().equals(this.error)) {
                    return new TestResult.TestSuccess();
                }
                return new TestResult.IncorrectError(this.error, ce);
            }
            return super.match(t);
        }
    }
}

