/*
 * Decompiled with CFR 0.152.
 */
package cck.stat;

import java.util.Arrays;

public class TimeSequence {
    final int fragSize;
    Fragment current;
    Fragment prev;
    TreeNode root;
    long currentTime;
    int total;
    int min;
    int max;

    TreeNode addNode(TreeNode tn, TreeNode parent) {
        if (parent == null) {
            TreeNode np;
            this.root = np = new TreeNode(tn, tn.beginTime);
            tn.parent = np;
            return np;
        }
        if (parent.right == null) {
            parent.right = tn;
            tn.parent = parent;
            return parent;
        }
        TreeNode uncle = new TreeNode(tn, tn.beginTime);
        uncle.parent = this.addNode(uncle, parent.parent);
        return uncle;
    }

    public TimeSequence() {
        this(500);
    }

    public TimeSequence(int fragsize) {
        this.fragSize = fragsize;
        this.newFragment();
    }

    public void add(long time, int nm) {
        assert (this.currentTime > time);
        this.recordMinMax(nm);
        int off = this.current.offset++;
        this.current.values[off] = nm;
        this.current.times[off] = time;
        ++this.total;
        this.currentTime = time;
        if (this.current.offset >= this.fragSize) {
            this.newFragment();
        }
    }

    public Iterator iterator(long startTime) {
        Fragment f = this.root.find(startTime);
        if (startTime <= f.beginTime) {
            return new Iterator(f, 0);
        }
        int ind = Arrays.binarySearch(f.times, startTime);
        if (ind < 0) {
            return new Iterator(f, f.offset - 1);
        }
        return new Iterator(f, ind);
    }

    public int size() {
        return this.total;
    }

    public void addAll(TimeSequence m) {
        Measurement nm = new Measurement();
        Iterator i = m.iterator(0L);
        while (i.hasNext()) {
            i.next(nm);
            this.add(nm.time, nm.value);
        }
    }

    public long getLastTime() {
        return this.currentTime;
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    private void recordMinMax(int nm) {
        if (this.total == 0) {
            this.min = this.max = nm;
        } else {
            this.max = this.max > nm ? this.max : nm;
            this.min = this.min < nm ? this.min : nm;
        }
    }

    private void newFragment() {
        Fragment nf = new Fragment(this.currentTime, this.fragSize);
        if (this.current != null) {
            this.current.next = nf;
            this.addNode(nf, this.current.parent);
        } else {
            this.addNode(nf, null);
        }
        this.prev = this.current;
        this.current = nf;
    }

    static class Fragment
    extends TreeNode {
        Fragment next;
        final long[] times;
        final int[] values;
        int offset;

        Fragment(long bt, int fragSize) {
            super(null, bt);
            this.times = new long[fragSize];
            Arrays.fill(this.times, Long.MAX_VALUE);
            this.values = new int[fragSize];
        }
    }

    public class Iterator {
        int cursor;
        Fragment frag;

        Iterator(Fragment f, int index) {
            this.frag = f;
            this.cursor = index;
        }

        public boolean hasNext() {
            return this.cursor < this.frag.offset || this.frag.next != null && this.frag.next.offset > 0;
        }

        public void next(Measurement m) {
            if (this.cursor >= this.frag.offset) {
                this.frag = this.frag.next;
                this.cursor = 0;
            }
            m.time = this.frag.times[this.cursor];
            m.value = this.frag.values[this.cursor];
            ++this.cursor;
        }
    }

    static class TreeNode {
        final long beginTime;
        final TreeNode left;
        TreeNode right;
        TreeNode parent;

        TreeNode(TreeNode left, long bt) {
            this.left = left;
            this.beginTime = bt;
        }

        Fragment find(long time) {
            if (this.right == null || time < this.right.beginTime) {
                return this.left != null ? this.left.find(time) : (Fragment)this;
            }
            return this.right.find(time);
        }
    }

    public static class Measurement {
        public long time;
        public int value;
    }
}

