/*
 * Decompiled with CFR 0.152.
 */
package cck.stat;

import java.util.LinkedList;
import java.util.NoSuchElementException;

public class Sequence {
    final LinkedList fragments;
    final int fragSize;
    int[] currentFrag;
    int offset;
    int total;
    int min;
    int max;

    public Sequence() {
        this(500);
    }

    public Sequence(int fragsize) {
        this.fragSize = fragsize;
        this.fragments = new LinkedList();
        this.newFragment();
    }

    public void add(int nm) {
        this.currentFrag[this.offset++] = nm;
        if (this.total == 0) {
            this.min = this.max = nm;
        } else if (nm > this.max) {
            this.max = nm;
        } else if (nm < this.min) {
            this.min = nm;
        }
        if (this.offset >= this.fragSize) {
            this.newFragment();
        }
        ++this.total;
    }

    public Iterator iterator(int start) {
        return new Iterator(start);
    }

    public int size() {
        return this.total;
    }

    public void addAll(Sequence m) {
        Iterator i = m.iterator(0);
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    private void newFragment() {
        this.currentFrag = new int[this.fragSize];
        this.fragments.add(this.currentFrag);
        this.offset = 0;
    }

    public class Iterator {
        int cursor;
        int[] frag;
        java.util.Iterator fiter;

        Iterator(int start) {
            this.fiter = Sequence.this.fragments.iterator();
            this.frag = (int[])this.fiter.next();
            while (start >= Sequence.this.fragSize && this.fiter.hasNext()) {
                this.frag = (int[])this.fiter.next();
                start -= Sequence.this.fragSize;
            }
            this.cursor = start;
        }

        public boolean hasNext() {
            return this.fiter.hasNext() || this.cursor < Sequence.this.offset;
        }

        public int next() {
            if (this.frag == Sequence.this.currentFrag) {
                if (this.cursor >= Sequence.this.offset) {
                    throw new NoSuchElementException();
                }
            } else if (this.cursor >= Sequence.this.fragSize) {
                this.frag = (int[])this.fiter.next();
                this.cursor = 0;
            }
            return this.frag[this.cursor++];
        }
    }
}

