/*
 * Decompiled with CFR 0.152.
 */
package cck.stat;

import cck.stat.Counter;
import cck.stat.DataItem;
import cck.text.Printer;
import java.util.Iterator;
import java.util.LinkedList;

public class Proportion
implements DataItem {
    protected final String name;
    protected LinkedList shares;
    protected int total;

    public Proportion(String newname) {
        this.name = newname;
        this.shares = new LinkedList();
    }

    public String getName() {
        return this.name;
    }

    public void print(Printer printer) {
        Iterator i = this.shares.iterator();
        printer.print("\n " + this.name);
        printer.print("\n---------------------------------------------------------------------");
        while (i.hasNext()) {
            Counter s = (Counter)i.next();
            s.print(printer);
        }
        printer.print("\n");
    }

    public Counter newCounter(String name) {
        Counter s = new Counter(name);
        this.shares.add(s);
        return s;
    }

    public void addCounter(Counter c) {
        this.shares.add(c);
    }

    public Counter getCounter(String name) {
        for (Counter s : this.shares) {
            if (!name.equals(s.getName())) continue;
            return s;
        }
        return null;
    }

    public float getFraction(String name) {
        this.process();
        Counter c = this.getCounter(name);
        return c == null ? -1.0f : (float)c.getTotal() / (float)this.total;
    }

    public void process() {
        Iterator i = this.shares.iterator();
        this.total = 0;
        while (i.hasNext()) {
            this.total += ((Counter)i.next()).getTotal();
        }
    }

    public boolean empty() {
        return this.shares.isEmpty();
    }
}

