/*
 * Decompiled with CFR 0.152.
 */
package cck.stat;

import cck.stat.DataItem;
import cck.text.Printer;

public class MinMaxMean
implements DataItem {
    protected final String name;
    public float mean;
    public int observedMaximum;
    public int observedMinimum;
    public int countMinimum;
    public int countMaximum;
    public int total;
    public int accumulation;
    protected boolean someData;
    protected String totalname;
    protected String cumulname;

    public MinMaxMean(String newname) {
        this.name = newname;
        this.totalname = "Total";
        this.cumulname = "Accumulation";
        this.someData = false;
    }

    public MinMaxMean(String newname, String tn, String cn) {
        this.name = newname;
        this.totalname = tn;
        this.cumulname = cn;
        this.someData = false;
    }

    public String getName() {
        return this.name;
    }

    public void record(int value) {
        if (!this.someData) {
            this.observedMinimum = this.observedMaximum = value;
            this.countMaximum = 1;
            this.countMinimum = 1;
            this.mean = value;
            this.accumulation = value;
            this.someData = true;
            this.total = 1;
            return;
        }
        if (value > this.observedMaximum) {
            this.observedMaximum = value;
            this.countMaximum = 1;
        } else if (value == this.observedMaximum) {
            ++this.countMaximum;
        }
        if (value < this.observedMinimum) {
            this.observedMinimum = value;
            this.countMinimum = 1;
        } else if (value == this.observedMinimum) {
            ++this.countMinimum;
        }
        this.accumulation += value;
        ++this.total;
    }

    public void process() {
        this.mean = (float)this.accumulation / (float)this.total;
    }

    public void print(Printer printer) {
        printer.print("\n " + this.name);
        printer.print("\n---------------------------------------------------------------------\n");
        if (this.totalname != null) {
            printer.print("   " + this.totalname + ": " + this.total);
        }
        if (this.cumulname != null) {
            printer.print("   " + this.cumulname + ": " + this.accumulation);
        }
        printer.print("\n Statistics: ");
        printer.print("\n   Minimum: " + this.observedMinimum + ", " + this.countMinimum + " occurences of min.");
        printer.print("\n   Maximum: " + this.observedMaximum + ", " + this.countMaximum + " occurences of max.");
        printer.print("\n   Mean: " + this.mean + '\n');
    }

    public MinMaxMean merge(MinMaxMean m) {
        MinMaxMean result = new MinMaxMean(this.name);
        if (m.observedMaximum > this.observedMaximum) {
            result.observedMaximum = m.observedMaximum;
            result.countMaximum = m.countMaximum;
        } else if (m.observedMaximum == this.observedMaximum) {
            result.observedMaximum = this.observedMaximum;
            result.countMaximum = this.countMaximum + m.countMaximum;
        } else {
            result.observedMaximum = this.observedMaximum;
            result.countMaximum = this.countMaximum;
        }
        if (m.observedMinimum < this.observedMinimum) {
            result.observedMinimum = m.observedMinimum;
            result.countMinimum = m.countMinimum;
        } else if (m.observedMinimum == this.observedMinimum) {
            result.observedMinimum = this.observedMinimum;
            result.countMinimum = this.countMinimum + m.countMinimum;
        } else {
            result.observedMinimum = this.observedMinimum;
            result.countMinimum = this.countMinimum;
        }
        result.total = this.total + m.total;
        result.accumulation = this.accumulation + m.accumulation;
        result.mean = (m.mean * (float)m.total + this.mean * (float)this.total) / (float)result.total;
        return result;
    }

    public boolean empty() {
        return !this.someData;
    }

    public String toString() {
        return this.name;
    }
}

