/*
 * Decompiled with CFR 0.152.
 */
package cck.stat;

import cck.stat.MinMaxMean;
import cck.text.Printer;
import cck.util.Util;

public class Distribution
extends MinMaxMean {
    public int[] distrib;
    public int median;
    public int distribMin;
    protected String distribname;

    public Distribution(String name) {
        super(name);
        this.distribMin = this.observedMinimum;
    }

    public Distribution(String newname, String tn, String cn) {
        super(newname, tn, cn);
        this.distribMin = this.observedMinimum;
    }

    public Distribution(String newname, String tn, String cn, String dn) {
        super(newname, tn, cn);
        this.distribname = dn;
        this.distribMin = this.observedMinimum;
    }

    public synchronized void record(int value) {
        if (!this.someData) {
            this.distrib = new int[1];
            this.distrib[0] = 1;
            this.distribMin = value;
            super.record(value);
            return;
        }
        int oldMax = this.observedMaximum;
        int oldMin = this.observedMinimum;
        super.record(value);
        if (this.observedMaximum > oldMax) {
            this.recomputeMaxDistrib(this.observedMaximum);
        } else if (this.observedMinimum < oldMin) {
            this.recomputeMinDistrib(this.observedMinimum);
        } else {
            this.incrementDistrib(value);
        }
    }

    public void print(Printer printer) {
        printer.print("\n " + this.name);
        printer.print("\n---------------------------------------------------------------------\n");
        if (this.totalname != null) {
            printer.print("   " + this.totalname + ": " + this.total);
        }
        if (this.cumulname != null) {
            printer.print("   " + this.cumulname + ": " + this.accumulation);
        }
        printer.print("\n Statistics: ");
        printer.print("\n   Minimum: " + this.observedMinimum + ", " + this.countMinimum + " occurences of min.");
        printer.print("\n   Maximum: " + this.observedMaximum + ", " + this.countMaximum + " occurences of max.");
        printer.print("\n   Mean: " + this.mean + ", Median: " + this.median + '\n');
        if (this.distribname != null) {
            printer.print("\n Distribution: ");
            this.printDistribution(printer, this.distribMin, this.distrib);
        }
    }

    protected void printDistribution(Printer printer, int base, int[] data) {
        int cntr;
        float scale = 1.0f;
        int num = data.length;
        if (num == 0) {
            printer.print("\n");
            return;
        }
        int max = data[0];
        for (cntr = 0; cntr < data.length; ++cntr) {
            if (data[cntr] <= max) continue;
            max = data[cntr];
        }
        if (max > 70) {
            scale = (float)max / 70.0f;
        }
        for (cntr = 0; cntr < num; ++cntr) {
            float fstars = (float)data[cntr] / scale;
            int stars = (int)fstars;
            if ((double)(fstars - (float)stars) >= 0.5) {
                ++stars;
            }
            if (data[cntr] == 0 && cntr > 0 && cntr < num - 1 && data[cntr - 1] == 0 && data[cntr + 1] == 0) {
                printer.print("\n   . . .");
                while (data[cntr + 1] == 0 && cntr < data.length - 1) {
                    ++cntr;
                }
            }
            printer.print("\n   " + (base + cntr) + ": " + data[cntr] + " \t");
            for (int scntr = 0; scntr < stars; ++scntr) {
                printer.print("*");
            }
        }
        printer.print("\n");
    }

    public void expandInterval(int min, int max) {
        int newsize;
        if (this.distribMin < min) {
            min = this.distribMin;
        }
        if (max < this.distribMin + this.distrib.length) {
            max = this.distribMin + this.distrib.length;
        }
        if ((newsize = max - min + 1) == this.distrib.length) {
            return;
        }
        int[] newdistrib = new int[newsize];
        System.arraycopy(this.distrib, 0, newdistrib, this.distribMin - min, this.distrib.length);
        this.distrib = newdistrib;
    }

    protected void incrementDistrib(int value) {
        int n = value - this.distribMin;
        this.distrib[n] = this.distrib[n] + 1;
    }

    protected void recomputeMaxDistrib(int newMax) {
        int newsize = 1 + newMax - this.distribMin;
        int[] newdistrib = new int[newsize];
        System.arraycopy(this.distrib, 0, newdistrib, 0, this.distrib.length);
        newdistrib[newsize - 1] = 1;
        this.distrib = newdistrib;
    }

    protected void recomputeMinDistrib(int newMin) {
        int mindiff = this.distribMin - newMin;
        int newsize = mindiff + this.distrib.length;
        int[] newdistrib = new int[newsize];
        System.arraycopy(this.distrib, 0, newdistrib, mindiff, this.distrib.length);
        newdistrib[0] = 1;
        this.distrib = newdistrib;
        this.distribMin = newMin;
    }

    public void process() {
        super.process();
        int mid = this.total / 2;
        if (this.distrib == null) {
            this.median = 0;
            return;
        }
        if (mid == 0) {
            this.median = this.observedMinimum;
        }
        this.median = this.observedMinimum - 1;
        for (int cntr = 0; cntr < this.distrib.length; ++cntr) {
            if ((mid -= this.distrib[cntr]) >= 0) continue;
            this.median = cntr + this.distribMin;
            break;
        }
    }

    public MinMaxMean merge(MinMaxMean m) {
        throw Util.unimplemented();
    }
}

