/*
 * Decompiled with CFR 0.152.
 */
package cck.parser;

import cck.parser.AbstractToken;
import cck.text.Terminal;

public class SourcePoint {
    public final String file;
    public final int beginLine;
    public final int endLine;
    public final int beginColumn;
    public final int endColumn;

    public SourcePoint(String m, int l, int bc, int ec) {
        this.file = m == null ? "(unknown)" : m;
        this.beginLine = l;
        this.endLine = l;
        this.beginColumn = bc;
        this.endColumn = ec;
    }

    public SourcePoint(String m, int l, int el, int bc, int ec) {
        this.file = m == null ? "(unknown)" : m;
        this.beginLine = l;
        this.endLine = el;
        this.beginColumn = bc;
        this.endColumn = ec;
    }

    public SourcePoint(SourcePoint l, SourcePoint r) {
        this.file = l.file;
        this.beginLine = l.beginLine;
        this.beginColumn = l.beginColumn;
        this.endColumn = r.endColumn;
        this.endLine = r.endLine;
    }

    public SourcePoint(AbstractToken l, AbstractToken r) {
        this.file = l.file;
        this.beginLine = l.beginLine;
        this.beginColumn = l.beginColumn;
        this.endLine = r.endLine;
        this.endColumn = r.endColumn;
    }

    public String toString() {
        return this.file + ' ' + this.beginLine + ':' + this.beginColumn;
    }

    public String toShortString() {
        return this.beginLine + ":" + this.beginColumn;
    }

    public void report() {
        Terminal.print("[");
        Terminal.printBrightBlue(this.file);
        Terminal.print(" @ ");
        Terminal.printBrightCyan(this.beginLine + ":" + this.beginColumn);
        Terminal.print("]");
    }
}

