/*
 * Decompiled with CFR 0.152.
 */
package cck.parser;

import cck.parser.SourcePoint;

public abstract class AbstractToken {
    public int beginLine;
    public int beginColumn;
    public int endLine;
    public int endColumn;
    public String image;
    public String file;

    public String toString() {
        return this.image;
    }

    public abstract AbstractToken getNextToken();

    public SourcePoint getSourcePoint() {
        return new SourcePoint(this.file, this.beginLine, this.endLine, this.beginColumn, this.endColumn);
    }

    public SourcePoint asSourcePoint(String f) {
        return new SourcePoint(f, this.beginLine, this.endLine, this.beginColumn, this.endColumn);
    }

    public static AbstractToken newToken(String img, SourcePoint pt) {
        AbstractToken t = new AbstractToken(){

            public AbstractToken getNextToken() {
                return null;
            }
        };
        t.image = img;
        if (pt != null) {
            t.file = pt.file;
            t.beginLine = pt.beginLine;
            t.beginColumn = pt.beginColumn;
            t.endLine = pt.endLine;
            t.endColumn = pt.endColumn;
        }
        return t;
    }
}

