/*
 * Decompiled with CFR 0.152.
 */
package cck.help;

import cck.help.ClassMapValueItem;
import cck.help.HelpItem;
import cck.help.SubcategoryItem;
import cck.text.StringUtil;
import cck.text.Terminal;
import cck.util.ClassMap;
import cck.util.Option;
import cck.util.Options;
import cck.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class HelpCategory
implements HelpItem {
    public final Options options = new Options();
    public String name;
    public final String help;
    private final LinkedList sections;
    public static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            HelpCategory c1 = (HelpCategory)o1;
            HelpCategory c2 = (HelpCategory)o2;
            return String.CASE_INSENSITIVE_ORDER.compare(c1.name, c2.name);
        }
    };

    protected Option.Bool newOption(String name, boolean val, String desc) {
        return this.options.newOption(name, val, desc);
    }

    protected Option.Long newOption(String name, long val, String desc) {
        return this.options.newOption(name, val, desc);
    }

    protected Option.Double newOption(String name, double val, String desc) {
        return this.options.newOption(name, val, desc);
    }

    protected Option.Interval newOption(String name, long l, long h, String desc) {
        return this.options.newOption(name, l, h, desc);
    }

    protected Option.Str newOption(String name, String val, String desc) {
        return this.options.newOption(name, val, desc);
    }

    protected Option.List newOptionList(String name, String val, String desc) {
        return this.options.newOptionList(name, val, desc);
    }

    public HelpCategory(String name, String help) {
        this.name = name;
        this.help = help;
        this.sections = new LinkedList();
    }

    public String getHelp() {
        return this.help;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String nm) {
        this.name = nm;
    }

    public void addSection(String title, String paragraph) {
        this.sections.addLast(new ParagraphSection(title, paragraph));
    }

    public void addOptionSection(String para, Options opts) {
        this.sections.addLast(new OptionsSection(para, opts));
    }

    public void addListSection(String title, String para, List l) {
        this.sections.addLast(new ListSection(title, para, l));
    }

    public void addSubcategorySection(String title, String para, List l) {
        Iterator i = l.iterator();
        LinkedList<SubcategoryItem> sl = new LinkedList<SubcategoryItem>();
        while (i.hasNext()) {
            HelpCategory hc = (HelpCategory)i.next();
            sl.addLast(new SubcategoryItem(4, hc));
        }
        this.addListSection(title, para, sl);
    }

    public void addOptionValueSection(String title, String para, String optname, ClassMap optvals) {
        LinkedList<ClassMapValueItem> list = new LinkedList<ClassMapValueItem>();
        for (String s : optvals.getSortedList()) {
            list.addLast(new ClassMapValueItem(4, optname, s, optvals));
        }
        this.addListSection(title, para, list);
    }

    public void addCommandExample(String prefix, String command) {
        throw Util.unimplemented();
    }

    public void printHelp() {
        for (Section s : this.sections) {
            s.printHelp();
        }
    }

    private class ListSection
    extends Section {
        final String title;
        final String para;
        final List list;

        ListSection(String t, String p, List l) {
            this.title = t;
            this.para = p;
            this.list = l;
        }

        void printHelp() {
            if (this.title != null) {
                Terminal.printBrightBlue(this.title);
                Terminal.println("\n");
            }
            Terminal.println(StringUtil.formatParagraphs(this.para, 0, 4, 78));
            Terminal.println("");
            for (HelpItem hi : this.list) {
                hi.printHelp();
            }
            Terminal.println("");
        }
    }

    private class OptionsSection
    extends Section {
        final String para;
        final Options options;

        OptionsSection(String para, Options opts) {
            this.para = para;
            this.options = opts;
        }

        void printHelp() {
            Terminal.printBrightBlue("OPTIONS");
            Terminal.println("\n");
            Terminal.println(StringUtil.formatParagraphs(this.para, 0, 4, 78));
            Terminal.println("");
            Collection c = this.options.getAllOptions();
            ArrayList<Option> l = Collections.list(Collections.enumeration(c));
            Collections.sort(l, Option.COMPARATOR);
            for (Option opt : l) {
                opt.printHelp();
            }
            Terminal.println("");
        }
    }

    private class ParagraphSection
    extends Section {
        final String title;
        final String para;

        ParagraphSection(String t, String p) {
            this.title = t;
            this.para = p;
        }

        void printHelp() {
            if (this.title != null) {
                Terminal.printBrightBlue(this.title);
                Terminal.println("\n");
            }
            Terminal.println(StringUtil.formatParagraphs(this.para, 0, 4, 78));
            Terminal.println("");
        }
    }

    private abstract class Section {
        private Section() {
        }

        abstract void printHelp();
    }
}

