/*
 * Decompiled with CFR 0.152.
 */
package cck.help;

import cck.help.HelpCategory;
import cck.help.HelpItem;
import cck.text.StringUtil;
import cck.text.Terminal;
import cck.util.ClassMap;

public class ClassMapValueItem
implements HelpItem {
    public final int indent;
    public final String optname;
    public final String optvalue;
    public final ClassMap map;
    boolean isHelpCategory;
    protected String help;

    public ClassMapValueItem(int indent, String optname, String optvalue, ClassMap map) {
        this.optname = optname;
        this.optvalue = optvalue;
        this.map = map;
        this.indent = indent;
    }

    public String getHelp() {
        if (this.help != null) {
            return this.help;
        }
        return this.computeHelp();
    }

    public void printHelp() {
        String h = this.getHelp();
        Terminal.print(StringUtil.space(this.indent));
        String name = this.isHelpCategory && Terminal.htmlColors ? "<a href=" + this.optvalue + ".html>" + this.optvalue + "</a>" : this.optvalue;
        Terminal.printPair(2, 11, this.optname, "=", name);
        Terminal.nextln();
        Terminal.println(StringUtil.formatParagraphs(h, this.indent + 4, 0, 78));
    }

    private String computeHelp() {
        try {
            HelpItem item = (HelpItem)this.map.getObjectOfClass(this.optvalue);
            this.help = item.getHelp();
            if (item instanceof HelpCategory) {
                this.isHelpCategory = true;
            }
        }
        catch (Throwable t) {
            return "(No help available for this item.)";
        }
        return this.help;
    }
}

