/*
 * Decompiled with CFR 0.152.
 */
package cck.elf;

import cck.elf.ELFDataInputStream;
import cck.elf.ELFHeader;
import cck.elf.ELFSectionHeaderTable;
import cck.elf.ELFStringTable;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ELFSymbolTable {
    public static final int STT_NOTYPE = 0;
    public static final int STT_OBJECT = 1;
    public static final int STT_FUNC = 2;
    public static final int STT_SECTION = 3;
    public static final int STT_FILE = 4;
    public static final int STT_LOPROC = 13;
    public static final int STT_HIPROC = 15;
    public static final int STB_LOCAL = 0;
    public static final int STB_GLOBAL = 1;
    public static final int STB_WEAK = 2;
    public static final int STB_LOPROC = 13;
    public static final int STB_HIPROC = 15;
    public final ELFHeader header;
    public final ELFSectionHeaderTable.Entry32 entry;
    public final Entry[] entries;
    protected ELFStringTable strtab;

    public ELFSymbolTable(ELFHeader header, ELFSectionHeaderTable.Entry32 entry) {
        this.header = header;
        this.entry = entry;
        this.entries = new Entry[entry.sh_size / entry.sh_entsize];
    }

    public void read(RandomAccessFile f) throws IOException {
        f.seek(this.entry.sh_offset);
        ELFDataInputStream is = new ELFDataInputStream(this.header, f);
        for (int cntr = 0; cntr < this.entries.length; ++cntr) {
            Entry e = new Entry();
            e.st_name = is.read_Elf32_Word();
            e.st_value = is.read_Elf32_Addr();
            e.st_size = is.read_Elf32_Word();
            e.st_info = is.read_Elf32_uchar();
            e.st_other = is.read_Elf32_uchar();
            e.st_shndx = is.read_Elf32_Half();
            this.entries[cntr] = e;
            for (int pad = 16; pad < this.entry.sh_entsize; ++pad) {
                f.read();
            }
        }
    }

    public void setStringTable(ELFStringTable str) {
        this.strtab = str;
    }

    public ELFStringTable getStringTable() {
        return this.strtab;
    }

    public class Entry {
        public int st_name;
        public int st_value;
        public int st_size;
        public int st_info;
        public int st_other;
        public short st_shndx;

        public String getBinding() {
            switch (this.st_info >> 4 & 0xF) {
                case 0: {
                    return "LOCAL";
                }
                case 1: {
                    return "GLOBAL";
                }
                case 2: {
                    return "WEAK";
                }
            }
            return "unknown";
        }

        public String getType() {
            switch (this.st_info & 0xF) {
                case 0: {
                    return "n";
                }
                case 1: {
                    return "object";
                }
                case 2: {
                    return "func";
                }
                case 3: {
                    return "section";
                }
                case 4: {
                    return "file";
                }
            }
            return "unknown";
        }

        public boolean isFunction() {
            return (this.st_info & 0xF) == 2;
        }

        public boolean isObject() {
            return (this.st_info & 0xF) == 1;
        }

        public String getName() {
            if (ELFSymbolTable.this.strtab != null) {
                return ELFSymbolTable.this.strtab.getString(this.st_name);
            }
            return "";
        }
    }
}

