/*
 * Decompiled with CFR 0.152.
 */
package cck.elf;

import cck.elf.ELFHeader;
import cck.elf.ELFSectionHeaderTable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;

public class ELFStringTable {
    protected final HashMap map;
    protected final byte[] data;
    protected final ELFSectionHeaderTable.Entry32 entry;

    public ELFStringTable(ELFHeader header, ELFSectionHeaderTable.Entry32 entry) {
        this.data = new byte[entry.sh_size];
        this.map = new HashMap();
        this.entry = entry;
    }

    public void read(RandomAccessFile f) throws IOException {
        if (this.data.length == 0) {
            return;
        }
        f.seek(this.entry.sh_offset);
        for (int read = 0; read < this.data.length; read += f.read(this.data, read, this.data.length - read)) {
        }
    }

    public String getString(int ind) {
        if (ind >= this.data.length) {
            return "";
        }
        String str = (String)this.map.get(new Integer(ind));
        if (str == null) {
            byte b;
            StringBuffer buf = new StringBuffer();
            for (int pos = ind; pos < this.data.length && (b = this.data[pos]) != 0; ++pos) {
                buf.append((char)b);
            }
            str = buf.toString();
            this.map.put(new Integer(ind), str);
        }
        return str;
    }
}

