/*
 * Decompiled with CFR 0.152.
 */
package cck.elf;

import cck.elf.ELFDataInputStream;
import cck.elf.ELFHeader;
import cck.elf.ELFStringTable;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ELFSectionHeaderTable {
    public static final int SHT_NULL = 0;
    public static final int SHT_PROGBITS = 1;
    public static final int SHT_SYMTAB = 2;
    public static final int SHT_STRTAB = 3;
    public static final int SHT_RELA = 4;
    public static final int SHT_HASH = 5;
    public static final int SHT_DYNAMIC = 6;
    public static final int SHT_NOTE = 7;
    public static final int SHT_NOBITS = 8;
    public static final int SHT_REL = 9;
    public static final int SHT_SHLIB = 10;
    public static final int SHT_DYNSYM = 11;
    public static final int SHT_LOPROC = 0x70000000;
    public static final int SHT_HIPROC = Integer.MAX_VALUE;
    public static final int SHT_LOUSER = Integer.MIN_VALUE;
    public static final int SHT_HIUSER = -1879048193;
    public static final int SHF_WRITE = 1;
    public static final int SHF_ALLOC = 2;
    public static final int SHF_EXECINSTR = 4;
    public static final int SHF_MASKPROC = -268435456;
    public final ELFHeader header;
    public final Entry32[] entries;
    protected ELFStringTable strtab;

    public ELFSectionHeaderTable(ELFHeader header) {
        this.header = header;
        this.entries = new Entry32[header.e_shnum];
    }

    public void read(RandomAccessFile fis) throws IOException {
        if (this.entries.length == 0) {
            return;
        }
        fis.seek(this.header.e_shoff);
        ELFDataInputStream is = new ELFDataInputStream(this.header, fis);
        for (int cntr = 0; cntr < this.entries.length; ++cntr) {
            Entry32 e = new Entry32();
            e.sh_name = is.read_Elf32_Word();
            e.sh_type = is.read_Elf32_Word();
            e.sh_flags = is.read_Elf32_Word();
            e.sh_addr = is.read_Elf32_Addr();
            e.sh_offset = is.read_Elf32_Off();
            e.sh_size = is.read_Elf32_Word();
            e.sh_link = is.read_Elf32_Word();
            e.sh_info = is.read_Elf32_Word();
            e.sh_addralign = is.read_Elf32_Word();
            e.sh_entsize = is.read_Elf32_Word();
            this.entries[cntr] = e;
            for (int pad = 40; pad < this.header.e_shentsize; ++pad) {
                fis.read();
            }
        }
    }

    public void setStringTable(ELFStringTable str) {
        this.strtab = str;
    }

    public ELFStringTable getStringTable() {
        return this.strtab;
    }

    public String getSectionName(int ind) {
        if (ind < 0 || ind >= this.entries.length) {
            return "";
        }
        Entry32 e = this.entries[ind];
        return e.getName();
    }

    public class Entry32 {
        public int sh_name;
        public int sh_type;
        public int sh_flags;
        public int sh_addr;
        public int sh_offset;
        public int sh_size;
        public int sh_link;
        public int sh_info;
        public int sh_addralign;
        public int sh_entsize;

        public String getType() {
            switch (this.sh_type) {
                case 0: {
                    return "null";
                }
                case 1: {
                    return "program";
                }
                case 2: {
                    return "symtab";
                }
                case 3: {
                    return "strtab";
                }
                case 4: {
                    return "rela";
                }
                case 5: {
                    return "hash";
                }
                case 6: {
                    return "dynamic";
                }
                case 7: {
                    return "note";
                }
                case 8: {
                    return "nobits";
                }
                case 9: {
                    return "rel";
                }
                case 10: {
                    return "shlib";
                }
                case 11: {
                    return "dynsym";
                }
            }
            return "unknown";
        }

        public String getFlags() {
            StringBuffer flags = new StringBuffer();
            if ((this.sh_flags & 1) != 0) {
                flags.append("WRITE ");
            }
            if ((this.sh_flags & 2) != 0) {
                flags.append("ALLOC ");
            }
            if ((this.sh_flags & 4) != 0) {
                flags.append("EXEC ");
            }
            return flags.toString();
        }

        public boolean isStringTable() {
            return this.sh_type == 3;
        }

        public boolean isSymbolTable() {
            return this.sh_type == 2;
        }

        public String getName() {
            if (ELFSectionHeaderTable.this.strtab != null) {
                return ELFSectionHeaderTable.this.strtab.getString(this.sh_name);
            }
            return "";
        }
    }
}

