/*
 * Decompiled with CFR 0.152.
 */
package cck.elf;

import cck.elf.ELFDataInputStream;
import cck.elf.ELFHeader;
import cck.text.StringUtil;
import cck.util.Util;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ELFProgramHeaderTable {
    public static final int PT_NULL = 0;
    public static final int PT_LOAD = 1;
    public static final int PT_DYNAMIC = 2;
    public static final int PT_INTERP = 3;
    public static final int PT_NOTE = 4;
    public static final int PT_SHLIB = 5;
    public static final int PT_PHDR = 6;
    public static final int PT_LOPROC = 0x70000000;
    public static final int PT_HIPROC = Integer.MAX_VALUE;
    public static final int PF_EXEC = 1;
    public static final int PF_WRITE = 2;
    public static final int PF_READ = 4;
    public final ELFHeader header;
    public final Entry32[] entries;

    public ELFProgramHeaderTable(ELFHeader header) {
        if (!header.is32Bit()) {
            throw Util.failure("Only 32 bit ELF files are supported.");
        }
        this.header = header;
        this.entries = new Entry32[header.e_phnum];
    }

    public void read(RandomAccessFile fis) throws IOException {
        if (this.entries.length == 0) {
            return;
        }
        fis.seek(this.header.e_phoff);
        ELFDataInputStream is = new ELFDataInputStream(this.header, fis);
        for (int cntr = 0; cntr < this.entries.length; ++cntr) {
            Entry32 e = new Entry32();
            e.p_type = is.read_Elf32_Word();
            e.p_offset = is.read_Elf32_Off();
            e.p_vaddr = is.read_Elf32_Addr();
            e.p_paddr = is.read_Elf32_Addr();
            e.p_filesz = is.read_Elf32_Word();
            e.p_memsz = is.read_Elf32_Word();
            e.p_flags = is.read_Elf32_Word();
            e.p_align = is.read_Elf32_Word();
            this.entries[cntr] = e;
            for (int pad = 32; pad < this.header.e_phentsize; ++pad) {
                fis.read();
            }
        }
    }

    public Entry32 getEntry(int ind) {
        return this.entries[ind];
    }

    public static String getType(Entry32 e) {
        switch (e.p_type) {
            case 0: {
                return "null";
            }
            case 1: {
                return "load";
            }
            case 2: {
                return "dynamic";
            }
            case 3: {
                return "interp";
            }
            case 4: {
                return "note";
            }
            case 5: {
                return "shlib";
            }
            case 6: {
                return "phdr";
            }
        }
        return StringUtil.toHex(e.p_type, 8);
    }

    public class Entry32 {
        public int p_type;
        public int p_offset;
        public int p_vaddr;
        public int p_paddr;
        public int p_filesz;
        public int p_memsz;
        public int p_flags;
        public int p_align;

        public String getFlags() {
            StringBuffer flags = new StringBuffer();
            if ((this.p_flags & 1) != 0) {
                flags.append("EXEC ");
            }
            if ((this.p_flags & 2) != 0) {
                flags.append("WRITE ");
            }
            if ((this.p_flags & 4) != 0) {
                flags.append("READ ");
            }
            return flags.toString();
        }

        public boolean isLoadable() {
            return this.p_type == 1;
        }

        public boolean isExecutable() {
            return (this.p_flags & 1) != 0;
        }
    }
}

