/*
 * Decompiled with CFR 0.152.
 */
package cck.elf;

import cck.elf.ELFHeader;
import cck.elf.ELFProgramHeaderTable;
import cck.elf.ELFSectionHeaderTable;
import cck.elf.ELFStringTable;
import cck.elf.ELFSymbolTable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.List;

public class ELFLoader {
    public static ELFHeader readELFHeader(RandomAccessFile fis) throws IOException, ELFHeader.FormatError {
        ELFHeader header = new ELFHeader();
        header.read(fis);
        return header;
    }

    public static ELFProgramHeaderTable readPHT(RandomAccessFile fis, ELFHeader header) throws IOException {
        ELFProgramHeaderTable pht = new ELFProgramHeaderTable(header);
        pht.read(fis);
        return pht;
    }

    public static ELFSectionHeaderTable readSHT(RandomAccessFile fis, ELFHeader header) throws IOException {
        ELFSectionHeaderTable sht = new ELFSectionHeaderTable(header);
        sht.read(fis);
        if (header.e_shstrndx < sht.entries.length) {
            ELFSectionHeaderTable.Entry32 e = sht.entries[header.e_shstrndx];
            ELFStringTable srttab = new ELFStringTable(header, e);
            srttab.read(fis);
            sht.setStringTable(srttab);
        }
        return sht;
    }

    public static List readSymbolTables(RandomAccessFile fis, ELFHeader header, ELFSectionHeaderTable sht) throws IOException {
        LinkedList<ELFSymbolTable> symbolTables = new LinkedList<ELFSymbolTable>();
        for (int cntr = 0; cntr < sht.entries.length; ++cntr) {
            ELFSectionHeaderTable.Entry32 e1 = sht.entries[cntr];
            if (!e1.isSymbolTable()) continue;
            ELFSymbolTable stab = new ELFSymbolTable(header, e1);
            stab.read(fis);
            symbolTables.add(stab);
            ELFSectionHeaderTable.Entry32 strent = sht.entries[e1.sh_link];
            if (!strent.isStringTable()) continue;
            ELFStringTable str = new ELFStringTable(header, strent);
            str.read(fis);
            stab.setStringTable(str);
        }
        return symbolTables;
    }
}

