/*
 * Decompiled with CFR 0.152.
 */
package cck.elf;

import cck.elf.ELFDataInputStream;
import cck.elf.ELFIdentifier;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ELFHeader {
    protected static final int ELFCLASSNONE = 0;
    protected static final int ELFCLASS32 = 1;
    protected static final int ELFCLASS64 = 2;
    protected static final int ELFCLASSNUM = 3;
    protected static final int EI_NIDENT = 16;
    protected static final int EI_CLASS = 4;
    protected static final int EI_DATA = 5;
    protected static final int EI_VERSION = 6;
    protected static final int EI_PAD = 7;
    protected static final int ELFDATA2LSB = 1;
    protected static final int ELFDATA2MSB = 2;
    public final byte[] e_ident = new byte[16];
    public short e_type;
    public short e_machine;
    public int e_version;
    public int e_entry;
    public int e_phoff;
    public int e_shoff;
    public int e_flags;
    public short e_ehsize;
    public short e_phentsize;
    public short e_phnum;
    public short e_shentsize;
    public short e_shnum;
    public short e_shstrndx;
    boolean bigEndian;

    public void read(RandomAccessFile fs) throws IOException, FormatError {
        if (fs.length() < 16L) {
            throw new FormatError();
        }
        for (int index = 0; index < 16; index += fs.read(this.e_ident, index, 16 - index)) {
        }
        this.checkIdent();
        ELFDataInputStream is = new ELFDataInputStream(this, fs);
        this.e_type = is.read_Elf32_Half();
        this.e_machine = is.read_Elf32_Half();
        this.e_version = is.read_Elf32_Word();
        this.e_entry = is.read_Elf32_Addr();
        this.e_phoff = is.read_Elf32_Off();
        this.e_shoff = is.read_Elf32_Off();
        this.e_flags = is.read_Elf32_Word();
        this.e_ehsize = is.read_Elf32_Half();
        this.e_phentsize = is.read_Elf32_Half();
        this.e_phnum = is.read_Elf32_Half();
        this.e_shentsize = is.read_Elf32_Half();
        this.e_shnum = is.read_Elf32_Half();
        this.e_shstrndx = is.read_Elf32_Half();
    }

    private void checkIdent() throws FormatError {
        this.checkIndentByte(0, 127);
        this.checkIndentByte(1, 69);
        this.checkIndentByte(2, 76);
        this.checkIndentByte(3, 70);
        this.bigEndian = this.isBigEndian();
    }

    private void checkIndentByte(int ind, int val) throws FormatError {
        if (this.e_ident[ind] != val) {
            throw new FormatError();
        }
    }

    public int getVersion() {
        return this.e_ident[6];
    }

    public String getArchitecture() {
        return ELFIdentifier.getArchitecture(this.e_machine);
    }

    public boolean isLittleEndian() {
        return this.e_ident[6] == 1;
    }

    public boolean isBigEndian() {
        return this.e_ident[6] == 2;
    }

    public boolean is32Bit() {
        return this.e_ident[4] == 1;
    }

    public boolean is64Bit() {
        return this.e_ident[4] == 2;
    }

    public class FormatError
    extends Exception {
    }
}

