/*
 * Decompiled with CFR 0.152.
 */
package cck.elf;

import cck.elf.ELFHeader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ELFDataInputStream {
    final boolean bigEndian;
    final ELFHeader header;
    final RandomAccessFile file;

    public ELFDataInputStream(ELFHeader header, RandomAccessFile f) {
        this.header = header;
        this.bigEndian = header.isBigEndian();
        this.file = f;
    }

    public byte[] read_section(int off, int length) throws IOException {
        byte[] buffer = new byte[length];
        this.file.seek(off);
        for (int cntr = 0; cntr < length; cntr += this.file.read(buffer, cntr, length - cntr)) {
        }
        return buffer;
    }

    public byte read_Elf32_byte() throws IOException {
        return (byte)this.read_1();
    }

    public int read_Elf32_uchar() throws IOException {
        return this.read_1();
    }

    public int read_Elf32_Addr() throws IOException {
        return this.read_4();
    }

    public short read_Elf32_Half() throws IOException {
        return (short)this.read_2();
    }

    public int read_Elf32_Off() throws IOException {
        return this.read_4();
    }

    public int read_Elf32_SWord() throws IOException {
        return this.read_4();
    }

    public int read_Elf32_Word() throws IOException {
        return this.read_4();
    }

    private int read_1() throws IOException {
        return this.file.read() & 0xFF;
    }

    private int read_2() throws IOException {
        int b1 = this.read_1();
        int b2 = this.read_1();
        if (this.bigEndian) {
            return this.asShort(b2, b1);
        }
        return this.asShort(b1, b2);
    }

    private int read_4() throws IOException {
        int b1 = this.read_1();
        int b2 = this.read_1();
        int b3 = this.read_1();
        int b4 = this.read_1();
        if (this.bigEndian) {
            return this.asInt(b4, b3, b2, b1);
        }
        return this.asInt(b1, b2, b3, b4);
    }

    private short asShort(int bl, int bh) {
        return (short)(bh << 8 | bl);
    }

    private int asInt(int b1, int b2, int b3, int b4) {
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }
}

