/*
 * Decompiled with CFR 0.152.
 */
package avrora.test.sim.msp430;

import avrora.arch.msp430.MSP430Interpreter;
import avrora.arch.msp430.MSP430Symbol;
import avrora.core.Program;
import avrora.sim.Simulator;
import avrora.test.sim.StateAccessor;
import cck.util.Arithmetic;
import cck.util.Util;

public class MSP430StateAccessor
extends StateAccessor {
    final MSP430Interpreter interpreter;

    public MSP430StateAccessor(Program p, Simulator s) {
        super(p, s);
        this.interpreter = (MSP430Interpreter)this.simulator.getInterpreter();
        for (int cntr = 0; cntr < 16; ++cntr) {
            this.accessors.put("r" + cntr, this.newRegister(cntr));
        }
        this.accessors.put("data", new DATA());
        this.accessors.put("regs", new REGS());
        this.accessors.put("pc", new PC());
        this.accessors.put("sp", new SP());
        this.accessors.put("cycles", new Cycles());
        this.accessors.put("C", new Flag(0));
        this.accessors.put("Z", new Flag(1));
        this.accessors.put("N", new Flag(2));
        this.accessors.put("V", new Flag(8));
    }

    Register newRegister(int cntr) {
        Register r = new Register();
        r.reg = MSP430Symbol.get_GPR("r" + cntr);
        return r;
    }

    class Cycles
    extends StateAccessor.Accessor {
        Cycles() {
            super(MSP430StateAccessor.this);
        }

        protected int get() {
            return (int)MSP430StateAccessor.this.interpreter.getState().getCycles();
        }

        protected void set(int val) {
            MSP430StateAccessor.this.interpreter.getMainClock().advance(val);
        }
    }

    class Flag
    extends StateAccessor.Accessor {
        final int bit;

        Flag(int b) {
            super(MSP430StateAccessor.this);
            this.bit = b;
        }

        protected int get() {
            return MSP430StateAccessor.this.interpreter.getSREG() >> this.bit & 1;
        }

        protected void set(int val) {
            int reg = MSP430StateAccessor.this.interpreter.getSREG();
            reg = Arithmetic.setBit(reg, this.bit, val != 0);
            MSP430StateAccessor.this.interpreter.setRegister(MSP430Symbol.GPR.SR, (char)reg);
        }
    }

    class REGS
    extends StateAccessor.Accessor {
        REGS() {
            super(MSP430StateAccessor.this);
        }

        protected int get() {
            return 0;
        }

        protected void set(int val) {
        }

        protected int getIndex(int ind) {
            return MSP430StateAccessor.this.interpreter.getRegister(ind);
        }

        protected void setIndex(int ind, int val) {
            throw Util.unimplemented();
        }
    }

    class DATA
    extends StateAccessor.Accessor {
        DATA() {
            super(MSP430StateAccessor.this);
        }

        protected int get() {
            return 0;
        }

        protected void set(int val) {
        }

        protected int getIndex(int ind) {
            return MSP430StateAccessor.this.interpreter.getSRAM(ind);
        }

        protected void setIndex(int ind, int val) {
            MSP430StateAccessor.this.interpreter.setData(ind, (char)val);
        }
    }

    class SP
    extends StateAccessor.Accessor {
        SP() {
            super(MSP430StateAccessor.this);
        }

        protected int get() {
            return MSP430StateAccessor.this.interpreter.getState().getSP();
        }

        protected void set(int val) {
            MSP430StateAccessor.this.interpreter.setRegister(MSP430Symbol.GPR.SP, (char)val);
        }
    }

    class PC
    extends StateAccessor.Accessor {
        PC() {
            super(MSP430StateAccessor.this);
        }

        protected int get() {
            return MSP430StateAccessor.this.interpreter.getState().getPC();
        }

        protected void set(int val) {
            throw Util.unimplemented();
        }
    }

    class Register
    extends StateAccessor.Accessor {
        MSP430Symbol.GPR reg;

        Register() {
            super(MSP430StateAccessor.this);
        }

        protected int get() {
            return MSP430StateAccessor.this.interpreter.getRegister(this.reg);
        }

        protected void set(int val) {
            MSP430StateAccessor.this.interpreter.setRegister(this.reg, (char)val);
        }
    }
}

