/*
 * Decompiled with CFR 0.152.
 */
package avrora.test.sim.legacy;

import avrora.arch.legacy.LegacyInterpreter;
import avrora.arch.legacy.LegacyRegister;
import avrora.core.Program;
import avrora.sim.Simulator;
import avrora.test.sim.StateAccessor;

public class LegacyStateAccessor
extends StateAccessor {
    final LegacyInterpreter interpreter;

    public LegacyStateAccessor(Program p, Simulator s) {
        super(p, s);
        int cntr;
        this.interpreter = (LegacyInterpreter)this.simulator.getInterpreter();
        for (cntr = 0; cntr < 32; ++cntr) {
            this.accessors.put("r" + cntr, this.newRegister(cntr));
        }
        for (cntr = 0; cntr < 32; cntr += 2) {
            WordRegister register = new WordRegister();
            register.reg = LegacyRegister.getRegisterByNumber(cntr);
            this.accessors.put("r" + cntr + ":r" + (cntr + 1), register);
        }
        this.installAR("x");
        this.installAR("y");
        this.installAR("z");
        this.accessors.put("sram", new SRAM());
        this.accessors.put("pc", new PC());
        this.accessors.put("sp", new SP());
        this.accessors.put("flash", new FLASH());
        this.accessors.put("cycles", new Cycles());
        this.accessors.put("flags.i", new Flag(7));
        this.accessors.put("flags.t", new Flag(6));
        this.accessors.put("flags.h", new Flag(5));
        this.accessors.put("flags.s", new Flag(4));
        this.accessors.put("flags.v", new Flag(3));
        this.accessors.put("flags.n", new Flag(2));
        this.accessors.put("flags.z", new Flag(1));
        this.accessors.put("flags.c", new Flag(0));
    }

    private void installAR(String name) {
        WordRegister register = new WordRegister();
        register.reg = LegacyRegister.getRegisterByName(name);
        this.accessors.put(name, register);
    }

    private Register newRegister(int cntr) {
        Register register = new Register();
        register.reg = LegacyRegister.getRegisterByNumber(cntr);
        return register;
    }

    class Cycles
    extends StateAccessor.Accessor {
        Cycles() {
            super(LegacyStateAccessor.this);
        }

        protected int get() {
            return (int)LegacyStateAccessor.this.interpreter.getState().getCycles();
        }

        protected void set(int val) {
            LegacyStateAccessor.this.interpreter.getMainClock().advance(val);
        }
    }

    class Flag
    extends StateAccessor.Accessor {
        final int bit;

        Flag(int b) {
            super(LegacyStateAccessor.this);
            this.bit = b;
        }

        protected int get() {
            return LegacyStateAccessor.this.interpreter.getFlag(this.bit) ? 1 : 0;
        }

        protected void set(int val) {
            LegacyStateAccessor.this.interpreter.setFlag(this.bit, val != 0);
        }
    }

    class FLASH
    extends StateAccessor.Accessor {
        FLASH() {
            super(LegacyStateAccessor.this);
        }

        protected int get() {
            return 0;
        }

        protected void set(int val) {
        }

        protected int getIndex(int ind) {
            return LegacyStateAccessor.this.interpreter.getFlashByte(ind);
        }

        protected void setIndex(int ind, int val) {
            LegacyStateAccessor.this.interpreter.writeFlashByte(ind, (byte)val);
        }
    }

    class SRAM
    extends StateAccessor.Accessor {
        SRAM() {
            super(LegacyStateAccessor.this);
        }

        protected int get() {
            return 0;
        }

        protected void set(int val) {
        }

        protected int getIndex(int ind) {
            return LegacyStateAccessor.this.interpreter.getDataByte(ind);
        }

        protected void setIndex(int ind, int val) {
            LegacyStateAccessor.this.interpreter.writeDataByte(ind, (byte)val);
        }
    }

    class SP
    extends StateAccessor.Accessor {
        SP() {
            super(LegacyStateAccessor.this);
        }

        protected int get() {
            return LegacyStateAccessor.this.interpreter.getState().getSP();
        }

        protected void set(int val) {
            LegacyStateAccessor.this.interpreter.setSP(val);
        }
    }

    class PC
    extends StateAccessor.Accessor {
        PC() {
            super(LegacyStateAccessor.this);
        }

        protected int get() {
            return LegacyStateAccessor.this.interpreter.getState().getPC();
        }

        protected void set(int val) {
            LegacyStateAccessor.this.interpreter.setBootPC(val);
        }
    }

    class WordRegister
    extends StateAccessor.Accessor {
        LegacyRegister reg;

        WordRegister() {
            super(LegacyStateAccessor.this);
        }

        protected int get() {
            return LegacyStateAccessor.this.interpreter.getRegisterWord(this.reg);
        }

        protected void set(int val) {
            LegacyStateAccessor.this.interpreter.writeRegisterWord(this.reg.getNumber(), val);
        }
    }

    class Register
    extends StateAccessor.Accessor {
        LegacyRegister reg;

        Register() {
            super(LegacyStateAccessor.this);
        }

        protected int get() {
            return LegacyStateAccessor.this.interpreter.getRegisterByte(this.reg);
        }

        protected void set(int val) {
            LegacyStateAccessor.this.interpreter.writeRegisterByte(this.reg.getNumber(), (byte)val);
        }
    }
}

