/*
 * Decompiled with CFR 0.152.
 */
package avrora.test.sim;

import avrora.core.Program;
import avrora.core.SourceMapping;
import avrora.test.sim.StateAccessor;

abstract class TestExpr {
    TestExpr() {
    }

    public abstract int evaluate(StateAccessor var1);

    public void set(StateAccessor access, int val) {
    }

    static class UnknownLabel
    extends RuntimeException {
        String name;

        UnknownLabel(String n) {
            this.name = n;
        }
    }

    static class Subtract
    extends BinOp {
        Subtract(TestExpr l, TestExpr r) {
            super(l, r, "-");
        }

        public int evaluate(StateAccessor access) {
            int lval = this.left.evaluate(access);
            int rval = this.right.evaluate(access);
            return lval - rval;
        }
    }

    static class Add
    extends BinOp {
        Add(TestExpr l, TestExpr r) {
            super(l, r, "+");
        }

        public int evaluate(StateAccessor access) {
            int lval = this.left.evaluate(access);
            int rval = this.right.evaluate(access);
            return lval + rval;
        }
    }

    static abstract class BinOp
    extends TestExpr {
        TestExpr left;
        TestExpr right;
        String op;

        BinOp(TestExpr l, TestExpr r, String o) {
            this.left = l;
            this.right = r;
            this.op = o;
        }

        public String toString() {
            return this.left + this.op + this.right;
        }
    }

    static class Const
    extends TestExpr {
        int value;

        Const(int v) {
            this.value = v;
        }

        public int evaluate(StateAccessor access) {
            return this.value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    static class Label
    extends TestExpr {
        String name;

        Label(String n) {
            this.name = n;
        }

        public int evaluate(StateAccessor access) {
            Program p = access.getProgram();
            SourceMapping smap = p.getSourceMapping();
            SourceMapping.Location l = smap.getLocation(this.name);
            if (l == null) {
                throw new UnknownLabel(this.name);
            }
            return l.lma_addr;
        }

        public String toString() {
            return this.name;
        }
    }

    static class Var
    extends TestExpr {
        final String name;

        Var(String name) {
            this.name = name;
        }

        public int evaluate(StateAccessor access) {
            return access.get(this.name);
        }

        public String toString() {
            return this.name;
        }

        public void set(StateAccessor access, int val) {
            access.set(this.name, val);
        }
    }

    static class Index
    extends TestExpr {
        final String name;
        final TestExpr index;

        Index(String name, TestExpr i) {
            this.name = name;
            this.index = i;
        }

        public int evaluate(StateAccessor access) {
            int indv = this.index.evaluate(access);
            return access.getIndex(this.name, indv);
        }

        public String toString() {
            return this.name + "[" + this.index + "]";
        }

        public void set(StateAccessor access, int val) {
            int indv = this.index.evaluate(access);
            access.setIndex(this.name, indv, val);
        }
    }
}

