/*
 * Decompiled with CFR 0.152.
 */
package avrora.test.sim;

import avrora.core.Program;
import avrora.sim.Simulator;
import avrora.test.sim.Predicate;
import cck.util.Arithmetic;
import cck.util.Util;
import java.util.HashMap;
import java.util.List;

public abstract class StateAccessor {
    protected final Program program;
    protected final Simulator simulator;
    protected final HashMap accessors;

    protected StateAccessor(Program p, Simulator sim) {
        this.program = p;
        this.simulator = sim;
        this.accessors = new HashMap();
    }

    public int get(String name) {
        Accessor a = (Accessor)this.accessors.get(name);
        if (a == null) {
            throw Util.failure("unknown variable " + name);
        }
        return a.get();
    }

    public int getIndex(String name, int ind) {
        Accessor a = (Accessor)this.accessors.get(name);
        if (a == null) {
            throw Util.failure("unknown variable " + name);
        }
        return a.getIndex(ind);
    }

    public void set(String name, int val) {
        Accessor a = (Accessor)this.accessors.get(name);
        if (a == null) {
            throw Util.failure("unknown variable " + name);
        }
        a.set(val);
    }

    public void setIndex(String name, int ind, int val) {
        Accessor a = (Accessor)this.accessors.get(name);
        if (a == null) {
            throw Util.failure("unknown variable " + name);
        }
        a.setIndex(ind, val);
    }

    public Program getProgram() {
        return this.program;
    }

    public Simulator getSimulator() {
        return this.simulator;
    }

    public void init(List inits) {
        for (Predicate p : inits) {
            p.init(this);
        }
    }

    protected abstract class Accessor {
        protected Accessor() {
        }

        protected abstract int get();

        protected abstract void set(int var1);

        protected int getIndex(int ind) {
            return Arithmetic.getBit(this.get(), ind) ? 1 : 0;
        }

        protected void setIndex(int ind, int val) {
            int value = Arithmetic.setBit(this.get(), ind, (val & 1) != 0);
            this.set(value);
        }
    }
}

