/*
 * Decompiled with CFR 0.152.
 */
package avrora.test.sim;

import avrora.Defaults;
import avrora.core.Program;
import avrora.core.ProgramReader;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.syntax.Module;
import avrora.test.sim.Predicate;
import avrora.test.sim.PredicateParser;
import avrora.test.sim.StateAccessor;
import avrora.test.sim.TestExpr;
import avrora.test.sim.Tester;
import avrora.test.sim.legacy.LegacyTester;
import avrora.test.sim.msp430.MSP430Tester;
import cck.test.TestCase;
import cck.test.TestEngine;
import cck.test.TestResult;
import cck.text.Terminal;
import cck.util.ClassMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class SimTestHarness
implements TestEngine.Harness {
    protected static final ClassMap testerMap = new ClassMap("Simulation Tester", Tester.class);

    public TestCase newTestCase(String fname, Properties props) throws Exception {
        return new SimulatorTest(fname, props);
    }

    static {
        testerMap.addClass("avr", LegacyTester.class);
        testerMap.addClass("msp430", MSP430Tester.class);
    }

    static class StateMismatch
    extends TestResult.TestFailure {
        Predicate predicate;
        State state;

        StateMismatch(Predicate pred, State st) {
            super("incorrect result: (" + pred.left + " -> " + pred.leftvalue + ") != (" + pred.right + " -> " + pred.rightvalue + ')');
            this.state = st;
            this.predicate = pred;
        }

        public void longReport() {
            Terminal.println(this.message);
        }
    }

    static class SimulatorTest
    extends TestCase {
        Module module;
        Simulator simulator;
        List predicates;
        List inits;
        Tester tester;
        StateAccessor access;

        SimulatorTest(String fname, Properties props) throws Exception {
            super(fname, props);
            String result = this.trimString(props.getProperty("Result"));
            PredicateParser pp = new PredicateParser();
            this.predicates = pp.parseResult(result);
            String init = props.getProperty("Init");
            if (init != null) {
                this.inits = pp.parseInitializers(this.trimString(init));
            }
            String arch = this.expectProperty("Arch");
            this.tester = (Tester)testerMap.getObjectOfClass(arch);
        }

        public void run() throws Exception {
            Program p = this.readProgram();
            this.simulator = this.initSimulator(p);
            this.simulator.start();
        }

        private Program readProgram() throws Exception {
            String format = this.expectProperty("Format");
            ProgramReader r = Defaults.getProgramReader(format);
            String arch = this.expectProperty("Arch");
            r.ARCH.set(arch);
            String[] args = new String[]{this.filename};
            return r.read(args);
        }

        private Simulator initSimulator(Program program) {
            Simulator sim = this.tester.newSimulator(program);
            this.access = this.tester.getAccessor(sim);
            if (this.inits != null) {
                this.access.init(this.inits);
            }
            return sim;
        }

        public TestResult match(Throwable t) {
            if (t != null) {
                return super.match(t);
            }
            State state = this.simulator.getState();
            Iterator i = this.predicates.iterator();
            try {
                while (i.hasNext()) {
                    Predicate p = (Predicate)i.next();
                    if (p.check(this.access)) continue;
                    return new StateMismatch(p, state);
                }
            }
            catch (TestExpr.UnknownLabel l) {
                return new TestResult.TestFailure("unknown label specified in predicate: " + l.name);
            }
            return new TestResult.TestSuccess();
        }
    }
}

