/*
 * Decompiled with CFR 0.152.
 */
package avrora.test.sim;

import avrora.test.sim.Predicate;
import avrora.test.sim.TestExpr;
import cck.text.StringUtil;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.LinkedList;
import java.util.List;

public class PredicateParser {
    public List parseInitializers(String init) throws Exception {
        LinkedList<Predicate> inits = new LinkedList<Predicate>();
        StringCharacterIterator i = new StringCharacterIterator(init);
        while (true) {
            StringUtil.skipWhiteSpace(i);
            Predicate s = this.readInit(i);
            StringUtil.skipWhiteSpace(i);
            inits.add(s);
            if (i.current() == '\uffff') break;
            StringUtil.expectChar(i, ',');
        }
        return inits;
    }

    public List parseResult(String result) throws Exception {
        LinkedList<Predicate> predicates = new LinkedList<Predicate>();
        StringCharacterIterator i = new StringCharacterIterator(result);
        while (true) {
            Predicate s = this.readPredicate(i);
            StringUtil.skipWhiteSpace(i);
            predicates.add(s);
            if (i.current() == '\uffff') break;
            StringUtil.expectChar(i, ',');
        }
        return predicates;
    }

    private Predicate readPredicate(CharacterIterator i) throws Exception {
        StringUtil.skipWhiteSpace(i);
        TestExpr left = this.readExpr(i);
        StringUtil.skipWhiteSpace(i);
        StringUtil.expectChar(i, '=');
        TestExpr right = this.readExpr(i);
        return new Predicate(left, right);
    }

    private Predicate readInit(CharacterIterator i) throws Exception {
        StringUtil.skipWhiteSpace(i);
        TestExpr left = this.readTerm(i);
        StringUtil.skipWhiteSpace(i);
        StringUtil.expectChar(i, '=');
        TestExpr right = this.readExpr(i);
        return new Predicate(left, right);
    }

    private TestExpr readExpr(CharacterIterator i) throws Exception {
        StringUtil.skipWhiteSpace(i);
        TestExpr t = this.readTerm(i);
        StringUtil.skipWhiteSpace(i);
        if (StringUtil.peekAndEat(i, '+')) {
            t = new TestExpr.Add(t, this.readExpr(i));
        } else if (StringUtil.peekAndEat(i, '-')) {
            t = new TestExpr.Subtract(t, this.readExpr(i));
        }
        return t;
    }

    private TestExpr readTerm(CharacterIterator i) throws Exception {
        TestExpr e;
        char c = i.current();
        if (c == '@') {
            i.next();
            TestExpr.Var v = this.readIdent(i);
            return new TestExpr.Label(v.name);
        }
        if (Character.isLetter(c)) {
            TestExpr.Var v = this.readIdent(i);
            if (StringUtil.peekAndEat(i, '[')) {
                TestExpr ind = this.readExpr(i);
                e = new TestExpr.Index(v.name, ind);
                StringUtil.expectChar(i, ']');
            } else {
                e = v;
            }
        } else if (Character.isDigit(c)) {
            e = this.readConst(i);
        } else if (c == '-') {
            e = this.readConst(i);
        } else {
            throw new Exception("invalid start of term @ " + i.getIndex());
        }
        return e;
    }

    private TestExpr.Var readIdent(CharacterIterator i) {
        char c;
        StringBuffer buf = new StringBuffer(32);
        while (Character.isLetterOrDigit(c = i.current()) || c == '.') {
            buf.append(c);
            i.next();
        }
        String name = buf.toString();
        return new TestExpr.Var(name);
    }

    private TestExpr readConst(CharacterIterator i) {
        return new TestExpr.Const(StringUtil.readIntegerValue(i));
    }
}

