/*
 * Decompiled with CFR 0.152.
 */
package avrora.test.probes;

import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.clock.DeltaQueue;
import avrora.sim.output.SimPrinter;
import avrora.sim.util.SimUtil;
import avrora.test.probes.Token;
import cck.text.StringUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ProbeTest {
    final HashMap entities = new HashMap();
    Simulator simulator;
    SimPrinter printer;
    DeltaQueue eventqueue;
    List mainCode;
    final List expectedEvents = new LinkedList();
    List recordedEvents;

    ProbeTest() {
    }

    protected void execute(List l) {
        for (Stmt s : l) {
            s.execute();
        }
    }

    protected void recordEvent(String e) {
        if (this.printer.enabled) {
            this.printer.println(e);
        }
        long time = this.simulator == null ? this.eventqueue.getCount() : this.simulator.getState().getCycles();
        this.recordedEvents.add(new Event(time, e));
    }

    public void newProbe(Token name, List b, List a) {
        TestProbe e = new TestProbe(name.image, b, a);
        this.entities.put(name.image, e);
    }

    public void newWatch(Token name, List b1, List a1, List b2, List a2) {
        TestWatch e = new TestWatch(name.image, b1, a1, b2, a2);
        this.entities.put(name.image, e);
    }

    public void newEvent(Token name, List b) {
        TestEvent e = new TestEvent(name.image, b);
        this.entities.put(name.image, e);
    }

    public void addInsert(List l, Token n, Token v) {
        l.add(new InsertStmt(n.image, StringUtil.evaluateIntegerLiteral(v.image)));
    }

    public void addRemove(List l, Token n, Token v) {
        l.add(new RemoveStmt(n.image, StringUtil.evaluateIntegerLiteral(v.image)));
    }

    public void addAdvance(List l, Token v) {
        l.add(new AdvanceStmt(StringUtil.evaluateIntegerLiteral(v.image)));
    }

    public void addRun(List l) {
        l.add(new RunStmt());
    }

    public void addMainCode(List l) {
        this.mainCode = l;
    }

    public void addResultEvent(Token time, Token name) {
        this.expectedEvents.add(new Event(StringUtil.evaluateIntegerLiteral(time.image), name.image));
    }

    public void run(Simulator s) throws Exception {
        this.simulator = s;
        this.printer = SimUtil.getPrinter(s, "test.probes");
        this.eventqueue = null;
        this.recordedEvents = new LinkedList();
        this.execute(this.mainCode);
        s.start();
        this.match();
    }

    public void run(DeltaQueue q) throws Exception {
        this.eventqueue = q;
        this.simulator = null;
        this.recordedEvents = new LinkedList();
        this.execute(this.mainCode);
        this.match();
    }

    public void match() throws Exception {
        Iterator e = this.expectedEvents.iterator();
        Iterator r = this.recordedEvents.iterator();
        int cntr = 1;
        while (e.hasNext()) {
            if (!r.hasNext()) {
                throw new Failure("too few events recorded");
            }
            Event expect = (Event)e.next();
            Event recorded = (Event)r.next();
            if (this.printer.enabled) {
                this.printer.println(" --> checking " + recorded.time + " " + recorded.name + " = " + expect.time + " " + expect.name);
            }
            if (!expect.name.equals(recorded.name)) {
                throw new Failure("incorrect event #" + cntr + ": " + recorded.name + " should be " + expect.name);
            }
            if (expect.time != recorded.time) {
                throw new Failure("timing incorrect for event #" + cntr + ": " + recorded.time + " should be " + expect.time);
            }
            ++cntr;
        }
        if (r.hasNext()) {
            throw new Failure("too many events recorded");
        }
    }

    public class Failure
    extends Exception {
        public final String reason;

        Failure(String s) {
            this.reason = s;
        }
    }

    class RunStmt
    extends Stmt {
        RunStmt() {
        }

        void execute() {
            ProbeTest.this.simulator.start();
        }
    }

    class AdvanceStmt
    extends Stmt {
        final int value;

        AdvanceStmt(int v) {
            this.value = v;
        }

        void execute() {
            ProbeTest.this.eventqueue.advance(this.value);
        }
    }

    class RemoveStmt
    extends Stmt {
        final String name;
        final int value;

        RemoveStmt(String n, int v) {
            this.name = n;
            this.value = v;
        }

        void execute() {
            TestEntity en = (TestEntity)ProbeTest.this.entities.get(this.name);
            en.remove(this.value);
        }
    }

    class InsertStmt
    extends Stmt {
        final String name;
        final int value;

        InsertStmt(String n, int v) {
            this.name = n;
            this.value = v;
        }

        void execute() {
            TestEntity en = (TestEntity)ProbeTest.this.entities.get(this.name);
            en.insert(this.value);
        }
    }

    abstract class Stmt {
        Stmt() {
        }

        abstract void execute();
    }

    public class TestEvent
    extends TestEntity
    implements Simulator.Event {
        List fireStmts;

        TestEvent(String name, List b) {
            super(name);
            this.fireStmts = b;
        }

        public void fire() {
            ProbeTest.this.recordEvent(this.name);
            ProbeTest.this.execute(this.fireStmts);
        }

        void insert(int value) {
            if (ProbeTest.this.simulator != null) {
                ProbeTest.this.simulator.insertEvent(this, value);
            } else {
                ProbeTest.this.eventqueue.insertEvent(this, value);
            }
        }

        void remove(int value) {
            if (ProbeTest.this.simulator != null) {
                ProbeTest.this.simulator.removeEvent(this);
            } else {
                ProbeTest.this.eventqueue.removeEvent(this);
            }
        }
    }

    public class TestWatch
    extends TestEntity
    implements Simulator.Watch {
        List beforeReadStmts;
        List afterReadStmts;
        List beforeWriteStmts;
        List afterWriteStmts;

        TestWatch(String name, List b1, List a1, List b2, List a2) {
            super(name);
            this.beforeReadStmts = b1;
            this.afterReadStmts = a1;
            this.beforeWriteStmts = b2;
            this.afterWriteStmts = a2;
        }

        public void fireBeforeRead(State state, int data_addr) {
            ProbeTest.this.recordEvent(this.name + ".beforeRead");
            ProbeTest.this.execute(this.beforeReadStmts);
        }

        public void fireBeforeWrite(State state, int data_addr, byte value) {
            ProbeTest.this.recordEvent(this.name + ".beforeWrite");
            ProbeTest.this.execute(this.beforeWriteStmts);
        }

        public void fireAfterRead(State state, int data_addr, byte value) {
            ProbeTest.this.recordEvent(this.name + ".afterRead");
            ProbeTest.this.execute(this.afterReadStmts);
        }

        public void fireAfterWrite(State state, int data_addr, byte value) {
            ProbeTest.this.recordEvent(this.name + ".afterWrite");
            ProbeTest.this.execute(this.afterWriteStmts);
        }

        void insert(int value) {
            ProbeTest.this.simulator.insertWatch(this, value);
        }

        void remove(int value) {
            ProbeTest.this.simulator.removeWatch(this, value);
        }
    }

    public class TestProbe
    extends TestEntity
    implements Simulator.Probe {
        List beforeStmts;
        List afterStmts;

        TestProbe(String name, List b, List a) {
            super(name);
            this.beforeStmts = b;
            this.afterStmts = a;
        }

        public void fireBefore(State s, int addr) {
            ProbeTest.this.recordEvent(this.name + ".before");
            ProbeTest.this.execute(this.beforeStmts);
        }

        public void fireAfter(State s, int addr) {
            ProbeTest.this.recordEvent(this.name + ".after");
            ProbeTest.this.execute(this.afterStmts);
        }

        void insert(int value) {
            ProbeTest.this.simulator.insertProbe(this, value);
        }

        void remove(int value) {
            ProbeTest.this.simulator.removeProbe(this, value);
        }
    }

    abstract class TestEntity {
        final String name;

        TestEntity(String n) {
            this.name = n;
        }

        abstract void insert(int var1);

        abstract void remove(int var1);
    }

    class Event {
        final long time;
        final String name;

        Event(long t, String n) {
            this.time = t;
            this.name = n;
        }
    }
}

