/*
 * Decompiled with CFR 0.152.
 */
package avrora.test;

import avrora.Defaults;
import avrora.core.Program;
import avrora.sim.AtmelInterpreter;
import avrora.sim.Simulator;
import avrora.sim.mcu.MicrocontrollerFactory;
import avrora.sim.platform.DefaultPlatform;
import avrora.sim.platform.Platform;
import avrora.syntax.elf.ELFParser;
import cck.text.Terminal;
import cck.util.Arithmetic;

public class VirgilRunner {
    protected final String binaryFile;
    protected final Program program;
    protected final DefaultPlatform.Factory factory;

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            Terminal.printRed("Usage");
            Terminal.println(": runner <program> <input>");
            System.exit(-1);
        }
        VirgilRunner vr = new VirgilRunner(args[0]);
        int input = Integer.parseInt(args[1]);
        int output = vr.run(145, 146, input);
        Terminal.println(Integer.toString(output));
        System.exit(output);
    }

    public VirgilRunner(String bf) throws Exception {
        this.binaryFile = bf;
        ELFParser p = new ELFParser();
        this.program = p.read(new String[]{this.binaryFile});
        MicrocontrollerFactory mcf = Defaults.getMicrocontroller("atmega128");
        this.factory = new DefaultPlatform.Factory(8000000L, 32768L, mcf);
    }

    public int run(int staddr, int ioaddr, int input) {
        Platform p = this.factory.newPlatform(0, this.program);
        Simulator sim = p.getMicrocontroller().getSimulator();
        AtmelInterpreter inter = (AtmelInterpreter)sim.getInterpreter();
        try {
            inter.writeDataByte(ioaddr, Arithmetic.low(input));
            inter.writeDataByte(ioaddr + 1, Arithmetic.high(input));
            sim.start();
        }
        catch (Throwable t) {
            return -1;
        }
        int status = inter.getDataByte(staddr);
        return status != 0 ? status : inter.getDataByte(ioaddr) & 0xFF;
    }
}

