/*
 * Decompiled with CFR 0.152.
 */
package avrora.test;

import avrora.Defaults;
import avrora.Main;
import avrora.core.Program;
import avrora.sim.Simulator;
import avrora.sim.util.InterruptScheduler;
import avrora.syntax.Module;
import avrora.test.probes.ProbeParser;
import avrora.test.probes.ProbeTest;
import cck.test.TestCase;
import cck.test.TestEngine;
import cck.test.TestResult;
import java.io.FileInputStream;
import java.util.Properties;

public class InterruptTestHarness
implements TestEngine.Harness {
    public TestCase newTestCase(String fname, Properties props) throws Exception {
        return new InterruptTestCase(fname, props);
    }

    class InterruptTestCase
    extends TestCase {
        Module module;
        Program program;
        ProbeTest probeTest;
        String progName;
        String interruptSched;

        InterruptTestCase(String fname, Properties props) throws Exception {
            super(fname, props);
            ProbeParser p = new ProbeParser(new FileInputStream(fname));
            this.probeTest = p.ProbeTest();
            this.progName = props.getProperty("Program");
            this.interruptSched = props.getProperty("Interrupt-schedule");
        }

        public void run() throws Exception {
            Program p = Main.loadProgram(new String[]{this.progName});
            Simulator s = Defaults.newSimulator(0, p);
            new InterruptScheduler(this.interruptSched, s);
            this.probeTest.run(s);
        }

        public TestResult match(Throwable t) {
            if (t instanceof ProbeTest.Failure) {
                return new TestResult.TestFailure(((ProbeTest.Failure)t).reason);
            }
            return super.match(t);
        }
    }
}

