/*
 * Decompiled with CFR 0.152.
 */
package avrora.test;

import avrora.arch.legacy.LegacyDisassembler;
import avrora.arch.legacy.LegacyInstr;
import avrora.core.Program;
import avrora.core.ProgramReader;
import avrora.syntax.Module;
import avrora.syntax.objdump.ObjDump2ProgramReader;
import cck.test.TestCase;
import cck.test.TestEngine;
import cck.test.TestResult;
import cck.text.StringUtil;
import java.util.Properties;

public class DisassemblerTestHarness
implements TestEngine.Harness {
    public TestCase newTestCase(String fname, Properties props) throws Exception {
        return new DisassemblerTest(fname, props);
    }

    class DisassemblerTest
    extends TestCase.ExpectSourceError {
        Module module;
        Program program;
        LegacyDisassembler disassembler;
        LegacyInstr[] instrs;

        DisassemblerTest(String fname, Properties props) {
            super(fname, props);
            this.disassembler = new LegacyDisassembler();
        }

        public void run() throws Exception {
            int cntr;
            ObjDump2ProgramReader r = new ObjDump2ProgramReader();
            String[] args = new String[]{this.filename};
            this.program = ((ProgramReader)r).read(args);
            byte[] data = new byte[this.program.program_end];
            this.instrs = new LegacyInstr[this.program.program_end];
            for (cntr = 0; cntr < this.program.program_end; ++cntr) {
                data[cntr] = this.program.readProgramByte(cntr);
            }
            cntr = 0;
            while (cntr < this.program.program_end) {
                LegacyInstr i = (LegacyInstr)this.program.readInstr(cntr);
                if (i != null) {
                    this.instrs[cntr] = this.disassembler.disassembleLegacy(data, 0, cntr);
                }
                cntr = this.program.getNextPC(cntr);
            }
        }

        public TestResult match(Throwable t) {
            int cntr = 0;
            while (cntr < this.program.program_end) {
                LegacyInstr id;
                LegacyInstr i = (LegacyInstr)this.program.readInstr(cntr);
                if (i != null && !i.equals(id = this.instrs[cntr])) {
                    return new TestResult.TestFailure("disassembler error at " + StringUtil.addrToString(cntr) + ", expected: " + i + " received: " + id);
                }
                cntr = this.program.getNextPC(cntr);
            }
            return new TestResult.TestSuccess();
        }
    }
}

