/*
 * Decompiled with CFR 0.152.
 */
package avrora.syntax.objdump;

import cck.text.StringUtil;
import cck.util.Util;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ObjDumpReformatter {
    HashSet sections = new HashSet();
    List sectlist;
    int line_count;

    public ObjDumpReformatter(List slist) {
        Iterator i = slist.iterator();
        while (i.hasNext()) {
            this.sections.add(i.next());
        }
        this.sectlist = slist;
    }

    public StringBuffer cleanCode(String inFile) throws IOException {
        try {
            StringBuffer out2 = new StringBuffer(200000);
            BufferedReader in2 = new BufferedReader(new FileReader(inFile));
            this.cleanFile(in2, out2);
            return out2;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw Util.unexpected(e);
        }
    }

    private void cleanFile(BufferedReader in2, StringBuffer out2) throws IOException {
        this.line_count = 0;
        String line = this.nextLine(in2);
        line = this.readHeader(in2, out2, line);
        while (line != null) {
            String section = this.getSectionName(line);
            if (section != null) {
                line = this.readSection(in2, out2, section);
                continue;
            }
            line = this.nextLine(in2);
        }
    }

    private String getSectionName(String line) {
        int offset = line.indexOf("Disassembly of section");
        if (offset != -1) {
            return line.substring(line.indexOf(46), line.indexOf(58));
        }
        return null;
    }

    private String readHeader(BufferedReader in2, StringBuffer out2, String line) throws IOException {
        while (line != null && line.indexOf("Disassembly of section") == -1) {
            if (line.indexOf("main.exe") != -1) {
                out2.append("program \"main.exe\":\n\n");
            }
            for (String s : this.sectlist) {
                if (line.indexOf(s) == -1) continue;
                this.printSectionHeader(s, out2, line);
            }
            line = this.nextLine(in2);
        }
        return line;
    }

    private void printSectionHeader(String section, StringBuffer out2, String line) {
        ObjDumpReformatter.append(out2, "  section ", section, " ");
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        st.nextToken();
        ObjDumpReformatter.append(out2, " size=0x", st.nextToken());
        ObjDumpReformatter.append(out2, " vma=0x", st.nextToken());
        ObjDumpReformatter.append(out2, " lma=0x", st.nextToken());
        ObjDumpReformatter.append(out2, " offset=0x", st.nextToken());
        ObjDumpReformatter.append(out2, " ;", st.nextToken());
        out2.append(" \n");
    }

    private static void append(StringBuffer out2, Object a, Object b) {
        out2.append(a);
        out2.append(b);
    }

    private static void append(StringBuffer out2, Object a, Object b, Object c) {
        out2.append(a);
        out2.append(b);
        out2.append(c);
    }

    private String readSection(BufferedReader in2, StringBuffer out2, String section) throws IOException {
        if (this.sections.contains(section)) {
            return this.convertSection(in2, out2, section);
        }
        return this.ignoreSection(in2, out2, section);
    }

    private String ignoreSection(BufferedReader in2, StringBuffer out2, String section) throws IOException {
        ObjDumpReformatter.append(out2, "; section ", section, " removed");
        String line = this.nextLine(in2);
        while (line != null) {
            ObjDumpReformatter.append(out2, "; ", line, "\n");
            if (this.getSectionName(line) != null) {
                return line;
            }
            line = this.nextLine(in2);
        }
        return line;
    }

    private String convertSection(BufferedReader in2, StringBuffer out2, String section) throws IOException {
        ObjDumpReformatter.append(out2, "\nstart ", section, ":\n");
        String line = this.nextLine(in2);
        while (line != null) {
            if (this.getSectionName(line) != null) {
                return line;
            }
            if (line.indexOf("...") != -1) {
                line = this.nextLine(in2);
                out2.append("; ...");
            }
            if (line.indexOf("Address ") != -1) {
                line = line.substring(0, line.indexOf("Address "));
                line = line + this.nextLine(in2);
            }
            if (this.isLabel(line)) {
                out2.append("label 0x");
                StringTokenizer st = new StringTokenizer(line);
                out2.append(st.nextToken());
                String name = st.nextToken().replaceAll("[<,>]", "\"");
                ObjDumpReformatter.append(out2, "  ", name, "\n");
            } else {
                StringTokenizer st = new StringTokenizer(line);
                if (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    out2.append(StringUtil.rightJustify("0x" + tok, 10));
                    while (st.hasMoreTokens()) {
                        tok = st.nextToken();
                        if (tok.matches("\\p{XDigit}\\p{XDigit}")) {
                            ObjDumpReformatter.append(out2, " 0x", tok);
                            continue;
                        }
                        if (tok.charAt(0) == '<') {
                            ObjDumpReformatter.append(out2, "; ", tok);
                            continue;
                        }
                        if (tok.startsWith("0x0x")) {
                            ObjDumpReformatter.append(out2, " ", tok.substring(2, tok.length()));
                            continue;
                        }
                        ObjDumpReformatter.append(out2, " ", tok);
                    }
                    out2.append('\n');
                }
            }
            line = this.nextLine(in2);
        }
        return line;
    }

    private String nextLine(BufferedReader in2) throws IOException {
        ++this.line_count;
        return in2.readLine();
    }

    private boolean isLabel(String s) {
        return s.indexOf(60) != -1 && s.indexOf(">:") != -1;
    }
}

