/*
 * Decompiled with CFR 0.152.
 */
package avrora.syntax.objdump;

import avrora.arch.legacy.LegacyArchitecture;
import avrora.core.Program;
import avrora.core.ProgramReader;
import avrora.syntax.RawModule;
import avrora.syntax.objdump.ObjDumpParser;
import avrora.syntax.objdump.ObjDumpReformatter;
import cck.util.Option;
import cck.util.Util;
import java.io.File;
import java.io.StringReader;

public class ObjDumpProgramReader
extends ProgramReader {
    protected final Option.List SECTIONS = this.newOptionList("sections", ".text,.data", "This option specifies a list of sections that the loader should load from the output.");

    public Program read(String[] args) throws Exception {
        if (args.length == 0) {
            Util.userError("no input files");
        }
        if (args.length != 1) {
            Util.userError("input type \"objdump\" accepts only one file at a time.");
        }
        if (this.getArchitecture() != LegacyArchitecture.INSTANCE) {
            Util.userError("input type  \"objdump\" parses only the \"legacy\" architecture.");
        }
        File f = new File(args[0]);
        RawModule module = new RawModule(true, true);
        StringBuffer buf = new ObjDumpReformatter(this.SECTIONS.get()).cleanCode(args[0]);
        StringReader r = new StringReader(buf.toString());
        ObjDumpParser parser = new ObjDumpParser(r, module, f.getName());
        parser.Module();
        Program p = module.build();
        this.addIndirectEdges(p);
        return p;
    }

    public ObjDumpProgramReader() {
        super("The \"objdump\" input format reads programs that are the output of the \"avr-objdump\" utility provided with avr-binutils. For example, an ELF file must first be disassembled with \"avr-objdump -zhD\" to create a text file readable by this input format. The \"-zhD\" options are very important: the output will not be parseable otherwise.");
    }
}

