/*
 * Decompiled with CFR 0.152.
 */
package avrora.syntax.objdump;

import avrora.arch.legacy.LegacyArchitecture;
import avrora.core.Program;
import avrora.core.ProgramReader;
import avrora.syntax.RawModule;
import avrora.syntax.objdump.ObjDumpParser;
import cck.util.Util;
import java.io.File;
import java.io.FileReader;

public class ObjDump2ProgramReader
extends ProgramReader {
    public Program read(String[] args) throws Exception {
        if (args.length == 0) {
            Util.userError("no input files");
        }
        if (args.length != 1) {
            Util.userError("input type \"odpp\" accepts only one file at a time.");
        }
        if (this.getArchitecture() != LegacyArchitecture.INSTANCE) {
            Util.userError("input type  \"odpp\" parses only the \"legacy\" architecture.");
        }
        File f = new File(args[0]);
        RawModule module = new RawModule(true, true);
        ObjDumpParser parser = new ObjDumpParser(new FileReader(f), module, f.getName());
        parser.Module();
        Program p = module.build();
        this.addIndirectEdges(p);
        return p;
    }

    public ObjDump2ProgramReader() {
        super("The \"odpp\" input format reads programs that are the output of the \"avr-objdump\" utility provided with avr-binutils and that have been preprocessed with Avrora's preprocessor utility. ");
    }
}

