/*
 * Decompiled with CFR 0.152.
 */
package avrora.syntax.objdump;

import avrora.actions.Action;
import avrora.syntax.objdump.ObjDumpReformatter;
import cck.util.Option;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class ODPPAction
extends Action {
    protected final Option.Str FILE = this.newOption("file", "", "The \"file\" option, when set, indicates the file to which to output the preprocessed objdump output.");
    protected final Option.List SECTIONS = this.newOptionList("sections", ".text,.data", "This option specifies a list of sections that the loader should load from the output.");
    private static final String HELP = "The \"odpp\" action tests the functionality of the objdump preprocessor that cleans up the output of objdump into something more suitable for automated parsing.";

    public ODPPAction() {
        super(HELP);
    }

    public ODPPAction(Option.List s) {
        super(HELP);
        this.SECTIONS.set(s.stringValue());
    }

    public void run(String[] args) throws Exception {
        ObjDumpReformatter rf = new ObjDumpReformatter(this.SECTIONS.get());
        if (this.FILE.isBlank()) {
            System.out.println(rf.cleanCode(args[0]));
        } else {
            FileOutputStream outf = new FileOutputStream(this.FILE.get());
            PrintWriter p = new PrintWriter(outf);
            p.write(rf.cleanCode(args[0]).toString());
            p.close();
        }
    }
}

