/*
 * Decompiled with CFR 0.152.
 */
package avrora.syntax.elf;

import avrora.Main;
import avrora.actions.ELFDumpAction;
import avrora.arch.AbstractArchitecture;
import avrora.arch.AbstractDisassembler;
import avrora.arch.AbstractInstr;
import avrora.arch.ArchitectureRegistry;
import avrora.core.Program;
import avrora.core.ProgramReader;
import avrora.core.SourceMapping;
import cck.elf.ELFDataInputStream;
import cck.elf.ELFHeader;
import cck.elf.ELFLoader;
import cck.elf.ELFProgramHeaderTable;
import cck.elf.ELFSectionHeaderTable;
import cck.elf.ELFStringTable;
import cck.elf.ELFSymbolTable;
import cck.text.StringUtil;
import cck.util.Option;
import cck.util.Util;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;

public class ELFParser
extends ProgramReader {
    ELFHeader header;
    ELFProgramHeaderTable pht;
    ELFSectionHeaderTable sht;
    List symbolTables;
    ELFStringTable shstrtab;
    AbstractArchitecture arch;
    protected final Option.Bool SYMBOLS = this.newOption("load-symbols", true, "This option causes the ELF loader to load the symbol table (if it exists) from the ELF file. The symbol table contains information about the names and sizes of data items and functions within the executable. Enabling this option allows for more source-level information during simulation, but disabling it speeds up loading of ELF files.");

    public ELFParser() {
        super("The \"elf\" format loader reads a program from an ELF (Executable and Linkable Format) as a binary and disassembles the sections corresponding to executable code.");
    }

    public Program read(String[] args) throws Exception {
        if (args.length == 0) {
            Util.userError("no input files");
        }
        if (args.length != 1) {
            Util.userError("input type \"elf\" accepts only one file at a time.");
        }
        String fname = args[0];
        Main.checkFileExists(fname);
        RandomAccessFile fis = new RandomAccessFile(fname, "r");
        try {
            this.header = ELFLoader.readELFHeader(fis);
        }
        catch (ELFHeader.FormatError e) {
            Util.userError(fname, "invalid ELF header");
        }
        this.arch = this.getArchitecture();
        this.pht = ELFLoader.readPHT(fis, this.header);
        if (this.SYMBOLS.get()) {
            this.sht = ELFLoader.readSHT(fis, this.header);
            this.shstrtab = this.sht.getStringTable();
        }
        Program p = this.loadSections(fis);
        this.loadSymbolTables(p, fis);
        return p;
    }

    private void loadSymbolTables(Program p, RandomAccessFile fis) throws IOException {
        SourceMapping map = new SourceMapping(p);
        p.setSourceMapping(map);
        if (this.SYMBOLS.get()) {
            this.symbolTables = ELFLoader.readSymbolTables(fis, this.header, this.sht);
            for (ELFSymbolTable stab : this.symbolTables) {
                this.addSymbols(map, stab, stab.getStringTable());
            }
        }
    }

    public AbstractArchitecture getArchitecture() {
        String specarch = this.ARCH.get();
        String filearch = this.header.getArchitecture();
        AbstractArchitecture farch = ArchitectureRegistry.getArchitecture(filearch);
        if (!"".equals(specarch) && farch != ArchitectureRegistry.getArchitecture(specarch)) {
            Util.userError("ELF Error", "expected " + StringUtil.quote(specarch) + " architecture, but header reports " + StringUtil.quote(filearch));
        }
        return farch;
    }

    private Program loadSections(RandomAccessFile fis) throws IOException {
        ELFDataInputStream is = new ELFDataInputStream(this.header, fis);
        Program p = this.createProgram();
        for (int cntr = 0; cntr < this.pht.entries.length; ++cntr) {
            ELFProgramHeaderTable.Entry32 e = this.pht.entries[cntr];
            if (!e.isLoadable() || e.p_filesz <= 0) continue;
            fis.seek(e.p_offset);
            byte[] sect = is.read_section(e.p_offset, e.p_filesz);
            p.writeProgramBytes(sect, e.p_paddr);
            if (!e.isExecutable()) continue;
            this.disassembleSection(sect, e, p);
        }
        return p;
    }

    private Program createProgram() {
        int minp = Integer.MAX_VALUE;
        int maxp = 0;
        for (int cntr = 0; cntr < this.pht.entries.length; ++cntr) {
            ELFProgramHeaderTable.Entry32 e = this.pht.entries[cntr];
            if (!e.isLoadable() || e.p_filesz <= 0) continue;
            int start = e.p_paddr;
            int end = start + e.p_filesz;
            if (start < minp) {
                minp = start;
            }
            if (end <= maxp) continue;
            maxp = end;
        }
        return new Program(this.arch, minp, maxp);
    }

    private void disassembleSection(byte[] sect, ELFProgramHeaderTable.Entry32 e, Program p) {
        AbstractDisassembler d = this.arch.getDisassembler();
        for (int off = 0; off < sect.length; off += 2) {
            AbstractInstr i = d.disassemble(e.p_paddr, off, sect);
            if (i == null) continue;
            p.writeInstr(i, e.p_paddr + off);
        }
    }

    private void addSymbols(SourceMapping map, ELFSymbolTable stab, ELFStringTable str) {
        for (int cntr = 0; cntr < stab.entries.length; ++cntr) {
            ELFSymbolTable.Entry e = stab.entries[cntr];
            if (!e.isFunction() && !e.isObject()) continue;
            String section = this.sht.getSectionName(e.st_shndx);
            String name = ELFDumpAction.getName(str, e.st_name);
            map.newLocation(section, name, e.st_value, this.findLMA(e));
        }
    }

    private int findLMA(ELFSymbolTable.Entry e) {
        int vma_start = this.sht.entries[e.st_shndx].sh_addr;
        for (int i = 0; i < this.pht.entries.length; ++i) {
            if (this.pht.entries[i].p_vaddr != vma_start) continue;
            return e.st_value - vma_start + this.pht.entries[i].p_paddr;
        }
        return 0;
    }
}

