/*
 * Decompiled with CFR 0.152.
 */
package avrora.syntax.atmel;

import avrora.arch.legacy.LegacyArchitecture;
import avrora.core.Program;
import avrora.core.ProgramReader;
import avrora.syntax.Module;
import avrora.syntax.atmel.AtmelParser;
import cck.util.Util;
import java.io.File;
import java.io.FileInputStream;

public class AtmelProgramReader
extends ProgramReader {
    public Program read(String[] args) throws Exception {
        if (args.length == 0) {
            Util.userError("no input files");
        }
        if (args.length != 1) {
            Util.userError("input type \"atmel\" accepts only one file at a time.");
        }
        if (this.getArchitecture() != LegacyArchitecture.INSTANCE) {
            Util.userError("input type  \"atmel\" parses only the \"legacy\" architecture.");
        }
        File f = new File(args[0]);
        Module module = new Module(false, false);
        FileInputStream fis = new FileInputStream(f);
        AtmelParser parser = new AtmelParser(fis, module, f.getName());
        parser.Module();
        Program p = module.build();
        this.addIndirectEdges(p);
        return p;
    }

    public AtmelProgramReader() {
        super("The \"atmel\" input format reads programs that are written in assembly language in the format supported by the Atmel assembler. Nearly all of the directives are supported, except macros.");
    }
}

