/*
 * Decompiled with CFR 0.152.
 */
package avrora.syntax;

import avrora.arch.legacy.LegacyOperand;
import avrora.arch.legacy.LegacyRegister;
import avrora.syntax.ASTNode;
import avrora.syntax.Context;
import cck.parser.AbstractToken;
import cck.util.Util;

public abstract class SyntacticOperand
extends ASTNode
implements LegacyOperand {
    protected final AbstractToken left;
    protected final AbstractToken right;

    public abstract void simplify(int var1, Context var2);

    protected SyntacticOperand(AbstractToken l, AbstractToken r) {
        this.left = l;
        this.right = r;
    }

    public AbstractToken getLeftMostToken() {
        return this.left;
    }

    public AbstractToken getRightMostToken() {
        return this.right;
    }

    public LegacyOperand.Register asRegister() {
        return null;
    }

    public LegacyOperand.Constant asConstant() {
        return null;
    }

    public static class Expr
    extends SyntacticOperand
    implements LegacyOperand.Constant {
        public final avrora.syntax.Expr expr;
        private boolean simplified;
        private boolean useByteAddress;
        private int value;

        public Expr(avrora.syntax.Expr e, boolean b) {
            super(e.getLeftMostToken(), e.getRightMostToken());
            this.expr = e;
            this.useByteAddress = b;
        }

        public LegacyOperand.Constant asConstant() {
            return this;
        }

        public int getValue() {
            if (!this.simplified) {
                throw Util.failure("expression operand not yet simplified: " + this.expr);
            }
            return this.value;
        }

        public int getValueAsWord() {
            if (!this.simplified) {
                throw Util.failure("expression operand not yet simplified: " + this.expr);
            }
            if (this.useByteAddress) {
                return this.value >> 1;
            }
            return this.value;
        }

        public void simplify(int nextByteAddress, Context c) {
            this.value = this.expr.evaluate(nextByteAddress, c);
            this.simplified = true;
        }

        public String toString() {
            return "expr:" + this.expr;
        }
    }

    public static class Register
    extends SyntacticOperand
    implements LegacyOperand.Register {
        public final AbstractToken name;
        private boolean simplified;
        private LegacyRegister register;

        public Register(AbstractToken n) {
            super(n, n);
            this.name = n;
        }

        public LegacyOperand.Register asRegister() {
            return this;
        }

        public LegacyRegister getRegister() {
            if (!this.simplified) {
                throw Util.failure("register operand not yet simplified: " + this.name);
            }
            return this.register;
        }

        public void simplify(int currentByteAddress, Context c) {
            this.register = c.getRegister(this.name);
            this.simplified = true;
        }

        public String toString() {
            return "reg:" + this.name.image;
        }
    }
}

