/*
 * Decompiled with CFR 0.152.
 */
package avrora.syntax;

import avrora.syntax.Expr;
import avrora.syntax.ExprList;
import avrora.syntax.Item;
import avrora.syntax.Module;
import avrora.syntax.objdump.Token;
import cck.parser.AbstractToken;
import cck.text.StringUtil;
import java.util.HashMap;

public class RawModule
extends Module {
    protected Section section;
    protected HashMap sectionMap = new HashMap();

    public RawModule(boolean cs, boolean ba) {
        super(cs, ba);
    }

    public void newSection(AbstractToken name, AbstractToken vma, AbstractToken lma) {
        Section s = new Section(name, vma, lma);
        this.sectionMap.put(name.image, s);
    }

    public void enterSection(AbstractToken sect) {
        this.section = (Section)this.sectionMap.get(sect.image);
        this.segment.setOrigin(this.section.lma_start);
    }

    public void addBytes(AbstractToken b1, AbstractToken b2) {
        ExprList list = new ExprList();
        list.add(new Expr.Constant(b1));
        list.add(new Expr.Constant(b2));
        this.addDataBytes(list);
    }

    public void addBytes(AbstractToken b1, AbstractToken b2, AbstractToken b3, AbstractToken b4) {
        ExprList list = new ExprList();
        list.add(new Expr.Constant(b1));
        list.add(new Expr.Constant(b2));
        list.add(new Expr.Constant(b3));
        list.add(new Expr.Constant(b4));
        this.addDataBytes(list);
    }

    public void setAddress(AbstractToken addr) {
        int address = StringUtil.evaluateIntegerLiteral(addr.image);
        address = address - this.section.vma_start + this.section.lma_start;
        this.segment.setOrigin(address);
    }

    public void addQuotedLabelAt(Token val, Token label) {
        label.image = StringUtil.trimquotes(label.image);
        int vma_addr = StringUtil.evaluateIntegerLiteral(val.image);
        int lma_addr = vma_addr - this.section.vma_start + this.section.lma_start;
        RawLabel li = new RawLabel(this.segment, label, vma_addr, lma_addr);
        this.addItem(li);
        this.labels.put(label.image.toLowerCase(), li);
    }

    protected void simplify(Item i) {
        try {
            i.simplify();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class RawLabel
    extends Item {
        private final AbstractToken name;
        private final int vma_addr;
        private final int lma_addr;

        RawLabel(Module.Seg s, AbstractToken name, int vma_addr, int lma_addr) {
            super(s);
            this.name = name;
            this.vma_addr = vma_addr;
            this.lma_addr = lma_addr;
        }

        public void simplify() {
            this.segment.addLabel(this.name.image, this.vma_addr, this.lma_addr);
        }

        public int getByteAddress() {
            return this.lma_addr;
        }

        public String toString() {
            return "label: " + this.name + " in " + this.segment.getName() + " @ " + this.lma_addr;
        }
    }

    private class Section {
        final AbstractToken name;
        final int vma_start;
        final int lma_start;

        Section(AbstractToken n, AbstractToken vma, AbstractToken lma) {
            this.name = n;
            this.vma_start = StringUtil.evaluateIntegerLiteral(vma.image);
            this.lma_start = StringUtil.evaluateIntegerLiteral(lma.image);
        }
    }
}

