/*
 * Decompiled with CFR 0.152.
 */
package avrora.syntax;

import avrora.arch.legacy.LegacyArchitecture;
import avrora.arch.legacy.LegacyInstr;
import avrora.arch.legacy.LegacyInstrProto;
import avrora.arch.legacy.LegacyInstrSet;
import avrora.arch.legacy.LegacyRegister;
import avrora.core.Program;
import avrora.core.SourceMapping;
import avrora.syntax.ASTNode;
import avrora.syntax.AVRErrorReporter;
import avrora.syntax.Context;
import avrora.syntax.Expr;
import avrora.syntax.ExprList;
import avrora.syntax.Item;
import avrora.syntax.SyntacticOperand;
import avrora.syntax.atmel.AtmelParser;
import cck.parser.AbstractParseException;
import cck.parser.AbstractToken;
import cck.text.StringUtil;
import cck.text.Verbose;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Module
implements Context {
    public final HashMap definitions;
    public final HashMap constants;
    public final HashMap labels;
    public final AVRErrorReporter ERROR;
    public final boolean caseSensitivity;
    public final boolean useByteAddresses;
    protected Seg segment;
    protected Seg programSegment;
    protected Seg dataSegment;
    protected Seg eepromSegment;
    public Program newprogram;
    private List itemList;
    static Verbose.Printer modulePrinter = Verbose.getVerbosePrinter("loader");
    private static final SyntacticOperand[] NO_OPERANDS = new SyntacticOperand[0];
    private SourceMapping sourceMapping;

    public Module(boolean cs, boolean ba) {
        this.caseSensitivity = cs;
        this.useByteAddresses = ba;
        this.definitions = new HashMap();
        this.constants = new HashMap();
        this.labels = new HashMap();
        this.programSegment = new Seg(".text", 2, 0, true, true);
        this.dataSegment = new Seg(".data", 1, 32, false, false);
        this.eepromSegment = new Seg(".eeprom", 1, 0, false, false);
        this.segment = this.programSegment;
        this.itemList = new LinkedList();
        this.addGlobalConstants();
        this.ERROR = new AVRErrorReporter();
    }

    public void addDefinition(AbstractToken name, AbstractToken rtok) {
        modulePrinter.println(".def " + this.labelName(name) + " = " + this.labelName(rtok));
        this.addItem(new Item.RegisterAlias(this.segment, name, rtok));
    }

    public void addConstant(AbstractToken name, Expr val) {
        modulePrinter.println(".equ " + this.labelName(name) + " = " + val);
        this.addItem(new Item.NamedConstant(this.segment, name, val));
    }

    public void enterDataSegment() {
        modulePrinter.println("enter segment: data");
        this.segment = this.dataSegment;
    }

    public void enterProgramSegment() {
        modulePrinter.println("enter segment: program");
        this.segment = this.programSegment;
    }

    public void enterEEPROMSegment() {
        modulePrinter.println("enter segment: eeprom");
        this.segment = this.eepromSegment;
    }

    private void print(String what, ASTNode where) {
        String addr = StringUtil.addrToString(this.segment.getCurrentAddress());
        modulePrinter.println(this.segment.getName() + " @ " + addr + ": " + what + " on line " + where.getLeftMostToken().beginLine);
    }

    private void print(String what, AbstractToken where) {
        String addr = StringUtil.addrToString(this.segment.getCurrentAddress());
        modulePrinter.println(this.segment.getName() + " @ " + addr + ": " + what + " on line " + where.beginLine);
    }

    public void addDataBytes(ExprList l) {
        this.print("addDataBytes", l);
        this.addItem(new Item.InitializedData(this.segment, l, 1));
    }

    public void addDataWords(ExprList l) {
        this.print("addDataWords", l);
        this.addItem(new Item.InitializedData(this.segment, l, 2));
    }

    public void addDataDoubleWords(ExprList l) {
        this.print("addDataDoubleWords", l);
        this.addItem(new Item.InitializedData(this.segment, l, 4));
    }

    public void setOrigin(Expr.Constant c) {
        int result = c.evaluate(this.segment.getCurrentAddress(), this);
        modulePrinter.println("setOrigin(" + c + ") -> " + result);
        this.segment.setOrigin(result);
    }

    public void reserveBytes(Expr e, Expr f) {
        int result = e.evaluate(this.segment.getCurrentAddress(), this);
        modulePrinter.println("reserveBytes(" + e + ") -> " + result);
        this.addItem(new Item.UninitializedData(this.segment, result));
    }

    public void includeFile(AbstractToken fname) throws AbstractParseException {
        try {
            modulePrinter.println("includeFile(" + fname.image + ')');
            String fn = StringUtil.trimquotes(fname.image);
            AtmelParser parser = new AtmelParser(new FileInputStream(fn), this, fn);
            parser.Module();
        }
        catch (FileNotFoundException e) {
            this.ERROR.IncludeFileNotFound(fname);
        }
    }

    public void addInstruction(String variant, AbstractToken name) {
        String v = StringUtil.quote(variant);
        this.print(StringUtil.embed("addInstr", v), name);
        SyntacticOperand[] o = NO_OPERANDS;
        this.makeInstr(variant, name, o);
    }

    public void addInstruction(String variant, AbstractToken name, SyntacticOperand o1) {
        String v = StringUtil.quote(variant);
        this.print(StringUtil.embed("addInstr", v, o1), name);
        SyntacticOperand[] o = new SyntacticOperand[]{o1};
        this.makeInstr(variant, name, o);
    }

    public void addInstruction(String variant, AbstractToken name, SyntacticOperand o1, SyntacticOperand o2) {
        String v = StringUtil.quote(variant);
        this.print(StringUtil.embed("addInstr", v, o1, o2), name);
        SyntacticOperand[] o = new SyntacticOperand[]{o1, o2};
        this.makeInstr(variant, name, o);
    }

    public void addInstruction(String variant, AbstractToken name, SyntacticOperand o1, SyntacticOperand o2, SyntacticOperand o3) {
        String v = StringUtil.quote(variant);
        this.print(StringUtil.embed("addInstr", v, o1, o2, o3), name);
        SyntacticOperand[] o = new SyntacticOperand[]{o1, o2, o3};
        this.makeInstr(variant, name, o);
    }

    public void addLabel(AbstractToken name) {
        Item.Label li = new Item.Label(this.segment, name);
        this.addItem(li);
        this.labels.put(name.image.toLowerCase(), li);
    }

    private void makeInstr(String variant, AbstractToken name, SyntacticOperand[] o) {
        LegacyInstrProto proto = LegacyInstrSet.getPrototype(variant);
        this.addItem(new Item.Instruction(this.segment, variant, name, proto, o));
    }

    public Program build() {
        this.newprogram = new Program(LegacyArchitecture.INSTANCE, this.programSegment.lowest_address, this.programSegment.highest_address);
        this.sourceMapping = new SourceMapping(this.newprogram);
        this.newprogram.setSourceMapping(this.sourceMapping);
        for (Item pos : this.itemList) {
            this.simplify(pos);
        }
        return this.newprogram;
    }

    protected void simplify(Item i) {
        Item.Instruction instr = null;
        if (i instanceof Item.Instruction) {
            instr = (Item.Instruction)i;
        }
        try {
            i.simplify();
        }
        catch (LegacyInstr.ImmediateRequired e) {
            this.ERROR.ConstantExpected((SyntacticOperand)e.operand);
        }
        catch (LegacyInstr.InvalidImmediate e) {
            this.ERROR.ConstantOutOfRange(instr.operands[e.number - 1], e.value, StringUtil.interval(e.low, e.high));
        }
        catch (LegacyInstr.InvalidRegister e) {
            this.ERROR.IncorrectRegister(instr.operands[e.number - 1], e.register, e.set.toString());
        }
        catch (LegacyInstr.RegisterRequired e) {
            this.ERROR.RegisterExpected((SyntacticOperand)e.operand);
        }
        catch (LegacyInstr.WrongNumberOfOperands e) {
            this.ERROR.WrongNumberOfOperands(instr.name, e.found, e.expected);
        }
    }

    public void addVariable(String name, int value) {
        this.constants.put(this.labelName(name), new Integer(value));
    }

    public void addRegisterName(String name, AbstractToken reg) {
        LegacyRegister register = LegacyRegister.getRegisterByName(reg.image);
        if (register == null) {
            this.ERROR.UnknownRegister(reg);
        }
        this.definitions.put(this.labelName(name), register);
    }

    public LegacyRegister getRegister(AbstractToken tok) {
        String name = this.labelName(tok);
        LegacyRegister reg = LegacyRegister.getRegisterByName(name);
        if (reg == null) {
            reg = (LegacyRegister)this.definitions.get(name);
        }
        if (reg == null) {
            this.ERROR.UnknownRegister(tok);
        }
        return reg;
    }

    public int getVariable(AbstractToken tok) {
        String name = this.labelName(tok);
        Integer v = (Integer)this.constants.get(name);
        if (v == null) {
            Item.Label li = (Item.Label)this.labels.get(name);
            if (li == null) {
                this.ERROR.UnknownVariable(tok);
            }
            if (li.segment == this.programSegment && !this.useByteAddresses) {
                return li.getByteAddress() >> 1;
            }
            return li.getByteAddress();
        }
        return v;
    }

    public SyntacticOperand.Expr newOperand(Expr e) {
        return new SyntacticOperand.Expr(e, this.useByteAddresses);
    }

    public SyntacticOperand.Register newOperand(AbstractToken tok) {
        return new SyntacticOperand.Register(tok);
    }

    protected void addItem(Item i) {
        this.itemList.add(i);
        this.segment.advance(i.itemSize());
    }

    public static int align(int val, int width) {
        if (val % width == 0) {
            return val;
        }
        return val + (width - val % width);
    }

    private String labelName(AbstractToken tok) {
        if (this.caseSensitivity) {
            return tok.image;
        }
        return tok.image.toLowerCase();
    }

    private String labelName(String n) {
        if (this.caseSensitivity) {
            return n;
        }
        return n.toLowerCase();
    }

    private void addGlobalConstants() {
        this.constant("RAMEND", 4095);
        this.ioreg("UCSR1C", 157);
        this.ioreg("UDR1", 156);
        this.ioreg("UCSR1A", 155);
        this.ioreg("UCSR1B", 154);
        this.ioreg("UBRR1L", 153);
        this.ioreg("UBRR1H", 152);
        this.ioreg("UCSR0C", 149);
        this.ioreg("UBRR0H", 144);
        this.ioreg("TCCR3C", 140);
        this.ioreg("TCCR3A", 139);
        this.ioreg("TCCR3B", 138);
        this.ioreg("TCNT3H", 137);
        this.ioreg("TCNT3L", 136);
        this.ioreg("OCR3AH", 135);
        this.ioreg("OCR3AL", 134);
        this.ioreg("OCR3BH", 133);
        this.ioreg("OCR3BL", 132);
        this.ioreg("OCR3CH", 131);
        this.ioreg("OCR3CL", 130);
        this.ioreg("ICR3H", 129);
        this.ioreg("ICR3L", 128);
        this.ioreg("ETIMSK", 125);
        this.ioreg("ETIFR", 124);
        this.ioreg("TCCR1C", 122);
        this.ioreg("OCR1CH", 121);
        this.ioreg("OCR1CL", 120);
        this.ioreg("TWCR", 116);
        this.ioreg("TWDR", 115);
        this.ioreg("TWAR", 114);
        this.ioreg("TWSR", 113);
        this.ioreg("TWBR", 112);
        this.ioreg("OSCCAL", 111);
        this.ioreg("XMCRA", 109);
        this.ioreg("XMCRB", 108);
        this.ioreg("EICRA", 106);
        this.ioreg("SPMCSR", 104);
        this.ioreg("PORTG", 101);
        this.ioreg("DDRG", 100);
        this.ioreg("PING", 99);
        this.ioreg("PORTF", 98);
        this.ioreg("DDRF", 97);
        this.ioreg("SREG", 63);
        this.ioreg("SPH", 62);
        this.ioreg("SPL", 61);
        this.ioreg("XDIV", 60);
        this.ioreg("RAMPZ", 59);
        this.ioreg("EICRB", 58);
        this.ioreg("EIMSK", 57);
        this.ioreg("EIFR", 56);
        this.ioreg("TIMSK", 55);
        this.ioreg("TIFR", 54);
        this.ioreg("MCUCR", 53);
        this.ioreg("MCUCSR", 52);
        this.ioreg("TCCR0", 51);
        this.ioreg("TCNT0", 50);
        this.ioreg("OCR0", 49);
        this.ioreg("ASSR", 48);
        this.ioreg("TCCR1A", 47);
        this.ioreg("TCCR1B", 46);
        this.ioreg("TCNT1H", 45);
        this.ioreg("TCNT1L", 44);
        this.ioreg("OCR1AH", 43);
        this.ioreg("OCR1AL", 42);
        this.ioreg("OCR1BH", 41);
        this.ioreg("OCR1BL", 40);
        this.ioreg("ICR1H", 39);
        this.ioreg("ICR1L", 38);
        this.ioreg("TCCR2", 37);
        this.ioreg("TCNT2", 36);
        this.ioreg("OCR2", 35);
        this.ioreg("OCDR", 34);
        this.ioreg("WDTCR", 33);
        this.ioreg("SFIOR", 32);
        this.ioreg("EEARH", 31);
        this.ioreg("EEARL", 30);
        this.ioreg("EEDR", 29);
        this.ioreg("EECR", 28);
        this.ioreg("PORTA", 27);
        this.ioreg("DDRA", 26);
        this.ioreg("PINA", 25);
        this.ioreg("PORTB", 24);
        this.ioreg("DDRB", 23);
        this.ioreg("PINB", 22);
        this.ioreg("PORTC", 21);
        this.ioreg("DDRC", 20);
        this.ioreg("PINC", 19);
        this.ioreg("PORTD", 18);
        this.ioreg("DDRD", 17);
        this.ioreg("PIND", 16);
        this.ioreg("SPDR", 15);
        this.ioreg("SPSR", 14);
        this.ioreg("SPCR", 13);
        this.ioreg("UDR0", 12);
        this.ioreg("UCSR0A", 11);
        this.ioreg("UCSR0B", 10);
        this.ioreg("UBRR0L", 9);
        this.ioreg("ACSR", 8);
        this.ioreg("ADMUX", 7);
        this.ioreg("ADCSRA", 6);
        this.ioreg("ADCH", 5);
        this.ioreg("ADCL", 4);
        this.ioreg("PORTE", 3);
        this.ioreg("DDRE", 2);
        this.ioreg("PINE", 1);
        this.ioreg("PINF", 0);
    }

    private void constant(String name, int value) {
        this.constants.put(name.toLowerCase(), new Integer(value));
    }

    private void ioreg(String name, int offset) {
        this.constants.put(name.toLowerCase(), new Integer(offset));
    }

    protected class Seg {
        private final String name;
        private final boolean acceptsInstrs;
        private final boolean acceptsData;
        int lowest_address;
        int highest_address;
        int cursor;
        final int align;

        Seg(String n, int a, int o, boolean i, boolean d) {
            this.name = n;
            this.acceptsInstrs = i;
            this.acceptsData = d;
            this.align = a;
            this.highest_address = this.cursor = o;
            this.lowest_address = this.cursor;
        }

        public Module getModule() {
            return Module.this;
        }

        public String getName() {
            return this.name;
        }

        public void writeDataBytes(ASTNode loc, int baddr, byte[] b) {
            if (this.acceptsData) {
                Module.this.newprogram.writeProgramBytes(b, baddr);
            } else {
                Module.this.ERROR.DataCannotBeInSegment(this.name, loc);
            }
        }

        public void writeDataByte(ASTNode loc, int baddr, byte b) {
            if (this.acceptsData) {
                Module.this.newprogram.writeProgramByte(b, baddr);
            } else {
                Module.this.ERROR.DataCannotBeInSegment(this.name, loc);
            }
        }

        public void writeInstr(AbstractToken loc, int baddr, LegacyInstr i) {
            if (this.acceptsInstrs) {
                Module.this.newprogram.writeInstr(i, baddr);
            } else {
                Module.this.ERROR.InstructionCannotBeInSegment(this.name, loc);
            }
        }

        public void addLabel(String name, int vma_addr, int lma_addr) {
            Module.this.sourceMapping.newLocation(this.name, name, vma_addr, lma_addr);
        }

        public void setOrigin(int org) {
            this.cursor = org;
            if (org < this.lowest_address) {
                this.lowest_address = org;
            }
            if (org > this.highest_address) {
                this.highest_address = org;
            }
        }

        public int getCurrentAddress() {
            return this.cursor;
        }

        public void advance(int dist) {
            this.cursor = Module.align(this.cursor + dist, this.align);
            if (this.cursor > this.highest_address) {
                this.highest_address = this.cursor;
            }
        }
    }
}

