/*
 * Decompiled with CFR 0.152.
 */
package avrora.syntax;

import avrora.arch.legacy.LegacyInstrProto;
import avrora.syntax.Expr;
import avrora.syntax.ExprList;
import avrora.syntax.Module;
import avrora.syntax.SyntacticOperand;
import cck.parser.AbstractToken;
import cck.util.Util;

public abstract class Item {
    protected final Module module;
    protected final Module.Seg segment;
    protected final int byteAddress;

    public abstract void simplify();

    protected Item(Module.Seg seg) {
        this.byteAddress = seg.getCurrentAddress();
        this.segment = seg;
        this.module = seg.getModule();
    }

    public int itemSize() {
        return 0;
    }

    public static class UninitializedData
    extends Item {
        private final int length;

        UninitializedData(Module.Seg s, int l) {
            super(s);
            this.length = l;
        }

        public void simplify() {
        }

        public String toString() {
            return "reserve " + this.length + " in " + this.segment.getName();
        }

        public int itemSize() {
            return this.length;
        }
    }

    public static class InitializedData
    extends Item {
        private final ExprList list;
        private final int width;
        private final int size;

        InitializedData(Module.Seg s, ExprList l, int w) {
            super(s);
            this.list = l;
            this.width = w;
            this.size = this.computeSize(l, w);
        }

        public void simplify() {
            int cursor = this.byteAddress;
            ExprList.ExprItem item = this.list.head;
            while (item != null) {
                Expr e = item.expr;
                cursor = e instanceof Expr.StringLiteral ? this.writeString(e, this.segment, cursor) : this.writeValue(e, this.module, this.segment, cursor);
                item = item.next;
            }
        }

        private int writeValue(Expr e, Module module, Module.Seg s, int cursor) {
            int val = e.evaluate(this.byteAddress, module);
            for (int cntr = 0; cntr < this.width; ++cntr) {
                s.writeDataByte(e, cursor, (byte)val);
                val >>= 8;
                ++cursor;
            }
            return cursor;
        }

        private int writeString(Expr e, Module.Seg s, int cursor) {
            String str = ((Expr.StringLiteral)e).value;
            s.writeDataBytes(e, cursor, str.getBytes());
            return this.align(cursor, this.width);
        }

        private int computeSize(ExprList l, int width) {
            int count = 0;
            ExprList.ExprItem item = l.head;
            while (item != null) {
                Expr e = item.expr;
                count = e instanceof Expr.StringLiteral ? (count += this.align(((Expr.StringLiteral)e).value.length(), width)) : (count += width);
                item = item.next;
            }
            return count;
        }

        private int align(int cursor, int width) {
            if (width > 1) {
                int i = cursor % width;
                cursor = i == 0 ? cursor : cursor + (i - width);
            }
            return cursor;
        }

        public int itemSize() {
            return this.size;
        }

        public String toString() {
            return "initialized data @ " + this.byteAddress;
        }
    }

    public static class Label
    extends Item {
        private final AbstractToken name;

        Label(Module.Seg s, AbstractToken n) {
            super(s);
            this.name = n;
        }

        public void simplify() {
            this.segment.addLabel(this.name.image, this.byteAddress, this.byteAddress);
        }

        public int getByteAddress() {
            return this.byteAddress;
        }

        public String toString() {
            return "label: " + this.name + " in " + this.segment.getName() + " @ " + this.byteAddress;
        }
    }

    public static class Instruction
    extends Item {
        protected final String variant;
        protected final AbstractToken name;
        protected final SyntacticOperand[] operands;
        protected final LegacyInstrProto proto;

        Instruction(Module.Seg s, String v, AbstractToken n, LegacyInstrProto p, SyntacticOperand[] ops) {
            super(s);
            this.variant = v;
            this.name = n;
            this.operands = ops;
            this.proto = p;
        }

        public void simplify() {
            if ((this.byteAddress & 1) == 1) {
                throw Util.failure("misaligned instruction");
            }
            for (int cntr = 0; cntr < this.operands.length; ++cntr) {
                this.operands[cntr].simplify(this.byteAddress + this.proto.getSize(), this.module);
            }
            this.segment.writeInstr(this.name, this.byteAddress, this.proto.build(this.byteAddress >> 1, this.operands));
        }

        public int itemSize() {
            return this.proto.getSize();
        }

        public String toString() {
            return "instr: " + this.variant + " @ " + this.byteAddress;
        }
    }

    public static class RegisterAlias
    extends Item {
        private final AbstractToken name;
        private final AbstractToken register;

        RegisterAlias(Module.Seg s, AbstractToken n, AbstractToken r) {
            super(s);
            this.name = n;
            this.register = r;
        }

        public void simplify() {
            this.module.addRegisterName(this.name.image, this.register);
        }

        public String toString() {
            return ".def " + this.name + " = " + this.register;
        }
    }

    public static class NamedConstant
    extends Item {
        private final AbstractToken name;
        private final Expr value;

        NamedConstant(Module.Seg s, AbstractToken n, Expr v) {
            super(s);
            this.name = n;
            this.value = v;
        }

        public void simplify() {
            int result = this.value.evaluate(this.byteAddress, this.module);
            this.module.addVariable(this.name.image, result);
        }

        public String toString() {
            return ".equ " + this.name;
        }
    }
}

